/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PluginStateManager {
    private static final List<PluginStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        myStateListeners.add(listener2);
    }

    public static void removeStateListener(@NotNull PluginStateListener listener2) {
        myStateListeners.remove(listener2);
    }

    static void fireState(@NotNull IdeaPluginDescriptor descriptor2, boolean install) {
        UIUtil.invokeLaterIfNeeded(() -> {
            for (PluginStateListener listener2 : myStateListeners) {
                if (install) {
                    listener2.install(descriptor2);
                    continue;
                }
                listener2.uninstall(descriptor2);
            }
        });
    }
}

