/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PluginManager {
    public static final String INSTALLED_TXT = "installed.txt";
    private final List<Runnable> disabledPluginListeners = new CopyOnWriteArrayList<Runnable>();

    @NotNull
    public static PluginManager getInstance() {
        return (PluginManager)ApplicationManager.getApplication().getService(PluginManager.class);
    }

    private PluginManager() {
        DisabledPluginsState.setDisabledPluginListener(() -> {
            for (Runnable listener2 : this.disabledPluginListeners) {
                listener2.run();
            }
        });
    }

    public void addDisablePluginListener(@NotNull Runnable listener2) {
        this.disabledPluginListeners.add(listener2);
    }

    public void removeDisablePluginListener(@NotNull Runnable listener2) {
        this.disabledPluginListeners.remove(listener2);
    }

    @Nullable
    public static Path getOnceInstalledIfExists() {
        Path onceInstalledFile = PathManager.getConfigDir().resolve(INSTALLED_TXT);
        return Files.isRegularFile(onceInstalledFile, new LinkOption[0]) ? onceInstalledFile : null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull String fileName) {
        return PluginManager.loadDescriptor(file2, fileName, DisabledPluginsState.disabledPlugins(), false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull String fileName, @NotNull Set<PluginId> disabledPlugins, boolean bundled, PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(disabledPlugins);
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, bundled, false, pathResolver);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file2, fileName, context, Files.isDirectory(file2, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Deprecated
    public static void processException(@NotNull Throwable t) {
        try {
            Class<?> aClass = PluginManager.class.getClassLoader().loadClass("com.intellij.ide.plugins.StartupAbortedException");
            Method method2 = aClass.getMethod("processException", Throwable.class);
            method2.setAccessible(true);
            method2.invoke(null, t);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        return PluginManagerCore.getPlugin(id2);
    }

    public static IdeaPluginDescriptor @NotNull [] getPlugins() {
        return PluginManagerCore.getPlugins();
    }

    public static boolean isPluginInstalled(PluginId id2) {
        return PluginManagerCore.isPluginInstalled(id2);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        return PluginManagerCore.getPluginByClassName(className);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins();
    }

    @Nullable
    public PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        return PluginManagerCore.getPluginOrPlatformByClassName(className);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        return DisabledPluginsState.getDisabledPlugins();
    }

    @Deprecated
    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        DisabledPluginsState.saveDisabledPlugins(ContainerUtil.map(ids, PluginId::getId), append);
    }

    public static boolean disablePlugin(@NotNull String id2) {
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id2) {
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    public boolean enablePlugin(@NotNull PluginId id2) {
        return PluginManagerCore.enablePlugin(id2);
    }

    @ApiStatus.Internal
    @NotNull
    public static Logger getLogger() {
        return PluginManagerCore.getLogger();
    }

    @ApiStatus.Internal
    public static void loadDescriptorFromFile(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Path file2, @Nullable SafeJdomFactory factory2, @NotNull Set<PluginId> disabledPlugins) throws IOException, JDOMException {
        int flags = 6;
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(flags, disabledPlugins, PluginManagerCore.createLoadingResult(null));
        descriptor2.readExternal(JDOMUtil.load((Path)file2, (SafeJdomFactory)factory2), PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, parentContext, descriptor2);
    }

    public boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin) {
        return this.isDevelopedByJetBrains(plugin.getVendor());
    }

    public boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (vendorString.equals("JetBrains")) {
            return true;
        }
        for (String vendor : StringUtil.split((String)vendorString, (String)",")) {
            if (!"JetBrains".equals(vendor.trim())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IdeaPluginDescriptor findEnabledPlugin(@NotNull PluginId id2) {
        List<IdeaPluginDescriptorImpl> result2 = PluginManagerCore.ourLoadedPlugins;
        if (result2 == null) {
            return null;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : result2) {
            if (id2 != ideaPluginDescriptor.getPluginId()) continue;
            return ideaPluginDescriptor;
        }
        return null;
    }

    public boolean hideImplementationDetails() {
        return !Registry.is((String)"plugins.show.implementation.details");
    }

    @ApiStatus.Internal
    public void setPlugins(@NotNull List<IdeaPluginDescriptor> descriptors) {
        IdeaPluginDescriptorImpl[] list2 = descriptors.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        PluginManagerCore.doSetPlugins(list2);
    }
}

