/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class PluginLoadingResult {
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @NotNull
    final Supplier<BuildNumber> productBuildNumber;
    final Map<PluginId, IdeaPluginDescriptorImpl> incompletePlugins = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
    private final Map<PluginId, IdeaPluginDescriptorImpl> plugins = new HashMap<PluginId, IdeaPluginDescriptorImpl>();
    final Map<PluginId, IdeaPluginDescriptorImpl> idMap = new ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl>();
    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final Map<PluginId, PluginError> errors = new ConcurrentHashMap<PluginId, PluginError>();
    private final Set<PluginId> shadowedBundledIds = new HashSet<PluginId>();
    private final boolean checkModuleDependencies;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;

    @NotNull
    List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        return this.enabledPlugins;
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber) {
        this(brokenPluginVersions, productBuildNumber, !PlatformUtils.isIntelliJ());
    }

    PluginLoadingResult(@NotNull Map<PluginId, Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
    }

    int enabledPluginCount() {
        return this.plugins.size();
    }

    void finishLoading() {
        IdeaPluginDescriptorImpl[] enabledPlugins = this.plugins.values().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(IdeaPluginDescriptorImpl::getPluginId));
        this.enabledPlugins = Arrays.asList(enabledPlugins);
    }

    boolean isBroken(@NotNull PluginId id2) {
        Set<String> set = this.brokenPluginVersions.get(id2);
        if (set == null) {
            return false;
        }
        IdeaPluginDescriptorImpl descriptor2 = this.idMap.get(id2);
        return descriptor2 != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    List<PluginError> getErrors() {
        if (this.errors.isEmpty()) {
            return Collections.emptyList();
        }
        PluginId[] ids = this.errors.keySet().toArray(PluginId.EMPTY_ARRAY);
        Arrays.sort(ids, null);
        ArrayList<PluginError> result2 = new ArrayList<PluginError>(ids.length);
        for (PluginId id2 : ids) {
            result2.add(this.errors.get(id2));
        }
        return result2;
    }

    void addIncompletePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable PluginError error) {
        if (!this.idMap.containsKey(plugin.getPluginId())) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
        }
        if (error != null) {
            this.errors.put(plugin.getPluginId(), error);
        }
    }

    void reportIncompatiblePlugin(@NotNull IdeaPluginDescriptorImpl plugin, @NotNull String reason, @Nullable String since, @Nullable String until) {
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        if (since == null) {
            since = "0.0";
        }
        if (until == null) {
            until = "*.*";
        }
        String message = "is incompatible (reason: " + reason + ", target build " + (since.equals(until) ? "is " + since : "range is " + since + " to " + until) + ")";
        this.errors.put(plugin.getPluginId(), new PluginError(plugin, message, reason));
    }

    void reportCannotLoad(@NotNull Path file2, Exception e) {
        DescriptorListLoadingContext.LOG.warn("Cannot load " + file2, (Throwable)e);
        this.errors.put(PluginId.getId((String)"__cannot load__"), new PluginError(null, "File \"" + FileUtil.getLocationRelativeToUserHome((String)file2.toString(), (boolean)false) + "\" contains invalid plugin descriptor", null));
    }

    boolean add(@NotNull IdeaPluginDescriptorImpl descriptor2, boolean overrideUseIfCompatible) {
        PluginId pluginId = descriptor2.getPluginId();
        if (pluginId == null) {
            PluginManagerCore.getLogger().warn("No id is provided by \"" + descriptor2.getPluginPath().getFileName().toString() + "\"");
            return true;
        }
        if (descriptor2.incomplete) {
            return true;
        }
        if (!descriptor2.isBundled() && this.checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            String message = "defines no module dependencies (supported only in IntelliJ IDEA)";
            this.errors.put(pluginId, new PluginError(descriptor2, message, "supported only in IntelliJ IDEA"));
            return false;
        }
        this.errors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor2);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor2);
            for (PluginId module : descriptor2.getModules()) {
                this.checkAndAdd(descriptor2, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor2.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor2) && (overrideUseIfCompatible || VersionComparatorUtil.compare((String)descriptor2.getVersion(), (String)prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor2.getPluginPath() + " overrides " + prevDescriptor.getPluginPath());
            this.idMap.put(pluginId, descriptor2);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private boolean isCompatible(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        return PluginManagerCore.getIncompatibleMessage(this.productBuildNumber.get(), descriptor2.getSinceBuild(), descriptor2.getUntilBuild()) == null;
    }

    private void checkAndAdd(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (this.duplicateModuleMap != null && (duplicates = this.duplicateModuleMap.get(id2)) != null) {
            duplicates.add(descriptor2);
            return;
        }
        IdeaPluginDescriptorImpl existingDescriptor = this.idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return;
        }
        this.idMap.remove(id2);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        this.duplicateModuleMap.put(id2, list2);
    }

    Set<PluginId> getShadowedBundledIds() {
        return this.shadowedBundledIds;
    }
}

