/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BasePathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathBasedJdomXIncluder<T> {
    private static final Logger LOG = Logger.getInstance(PathBasedJdomXIncluder.class);
    public static final PathResolver<Path> DEFAULT_PATH_RESOLVER = new BasePathResolver();
    private static final String INCLUDE = "include";
    private static final String HREF = "href";
    private static final String BASE = "base";
    private static final String PARSE = "parse";
    private static final String XML = "xml";
    private static final String XPOINTER = "xpointer";
    private final DescriptorListLoadingContext context;
    private final PathResolver<T> pathResolver;

    private PathBasedJdomXIncluder(@NotNull DescriptorListLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        this.context = context;
        this.pathResolver = pathResolver;
    }

    public static <T> void resolveNonXIncludeElement(@NotNull Element original, @Nullable Path base, @NotNull DescriptorListLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        LOG.assertTrue(!PathBasedJdomXIncluder.isIncludeElement(original));
        super.resolveNonXIncludeElement(original, pathResolver.createNewStack(base));
    }

    private static boolean isIncludeElement(Element element2) {
        return element2.getName().equals(INCLUDE) && element2.getNamespace().equals((Object)JDOMUtil.XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolveXIncludeElement(@NotNull Element linkElement, @NotNull List<T> bases, @Nullable ArrayList<Element> result2) {
        String xpointer;
        Element remoteParsed;
        String relativePath = linkElement.getAttributeValue(HREF);
        if (relativePath == null) {
            throw new RuntimeException("Missing href attribute");
        }
        String parseAttribute = linkElement.getAttributeValue(PARSE);
        if (parseAttribute != null) {
            LOG.assertTrue(parseAttribute.equals(XML), (Object)(parseAttribute + " is not a legal value for the parse attribute"));
        }
        if ((remoteParsed = this.parseRemote(bases, relativePath, linkElement)) != null && (xpointer = linkElement.getAttributeValue(XPOINTER)) != null) {
            remoteParsed = PathBasedJdomXIncluder.extractNeededChildren(remoteParsed, xpointer);
        }
        if (remoteParsed == null) {
            return result2 == null ? Collections.emptyList() : result2;
        }
        if (result2 == null) {
            result2 = new ArrayList(remoteParsed.getContentSize());
        } else {
            result2.ensureCapacity(result2.size() + remoteParsed.getContentSize());
        }
        Iterator iterator2 = remoteParsed.getContent().iterator();
        while (iterator2.hasNext()) {
            Content content2 = (Content)iterator2.next();
            if (!(content2 instanceof Element)) continue;
            iterator2.remove();
            Element element2 = (Element)content2;
            if (PathBasedJdomXIncluder.isIncludeElement(element2)) {
                this.resolveXIncludeElement(element2, bases, result2);
                continue;
            }
            this.resolveNonXIncludeElement(element2, bases);
            result2.add(element2);
        }
        return result2;
    }

    @Nullable
    private static Element extractNeededChildren(@NotNull Element remoteElement, @NotNull String xpointer) {
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher.matches()) {
            throw new RuntimeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new RuntimeException("Unsupported pointer: " + pointer);
        }
        Element result2 = remoteElement;
        if (!result2.getName().equals(matcher.group(1))) {
            return null;
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            result2 = result2.getChild(subTagName.substring(1));
            assert (result2 != null);
        }
        return result2;
    }

    @Nullable
    private Element parseRemote(@NotNull List<T> bases, @NotNull String relativePath, @NotNull Element referrerElement) {
        int baseStackSize = bases.size();
        try {
            Element root;
            String base = referrerElement.getAttributeValue(BASE, Namespace.XML_NAMESPACE);
            if (base != null) {
                LOG.error("Do not use xml:base attribute: " + base);
            }
            if (PathBasedJdomXIncluder.isIncludeElement(root = this.pathResolver.resolvePath(bases, relativePath, base, this.context.getXmlFactory()))) {
                throw new UnsupportedOperationException("root tag of remote cannot be include");
            }
            this.resolveNonXIncludeElement(root, bases);
            Element element2 = root;
            return element2;
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            Element fallbackElement = referrerElement.getChild("fallback", referrerElement.getNamespace());
            if (fallbackElement != null) {
                Element element3 = null;
                return element3;
            }
            if (this.context.ignoreMissingInclude) {
                LOG.info(relativePath + " include ignored: " + e.getMessage());
                Element element4 = null;
                return element4;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (baseStackSize != bases.size()) {
                bases.remove(bases.size() - 1);
            }
        }
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull List<T> bases) {
        List contentList = original.getContent();
        for (int i2 = contentList.size() - 1; i2 >= 0; --i2) {
            Content content2 = (Content)contentList.get(i2);
            if (!(content2 instanceof Element)) continue;
            Element element2 = (Element)content2;
            if (PathBasedJdomXIncluder.isIncludeElement(element2)) {
                original.setContent(i2, this.resolveXIncludeElement(element2, bases, null));
                continue;
            }
            this.resolveNonXIncludeElement(element2, bases);
        }
    }

    static interface PathResolver<T> {
        @NotNull
        public Element resolvePath(@NotNull List<T> var1, @NotNull String var2, @Nullable String var3, @NotNull SafeJdomFactory var4) throws IOException, JDOMException;

        @NotNull
        public Element resolvePath(@NotNull Path var1, @NotNull String var2, @NotNull SafeJdomFactory var3) throws IOException, JDOMException;

        @NotNull
        public List<T> createNewStack(@Nullable Path var1);
    }
}

