/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DynamicPluginVfsListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "()V", "initialRefreshDone", "", "findPluginByPath", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "path", "", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "Companion", "intellij.platform.ide.impl"})
public final class DynamicPluginVfsListener
implements AsyncFileListener {
    private boolean initialRefreshDone;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Iterable $this$mapTo$iv$iv;
        IdeaPluginDescriptorImpl it;
        Iterable $this$filterTo$iv$iv;
        if (!SystemProperties.is((String)"idea.auto.reload.plugins")) {
            return null;
        }
        if (!this.initialRefreshDone) {
            return null;
        }
        boolean bl = false;
        HashSet<IdeaPluginDescriptorImpl> pluginsToReload = new HashSet<IdeaPluginDescriptorImpl>();
        for (VFileEvent vFileEvent : events) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            if (this.findPluginByPath(((VFileContentChangeEvent)vFileEvent).getPath()) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            IdeaPluginDescriptorImpl it2 = ideaPluginDescriptorImpl;
            boolean bl4 = false;
            LOG.info("Detected plugin .jar file change " + ((VFileContentChangeEvent)vFileEvent).getPath() + ", reloading plugin");
            pluginsToReload.add(it2);
        }
        Iterable $this$filter$iv = pluginsToReload;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl5 = false;
            if (!it.isEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadFullDescriptor(it);
            collection.add(ideaPluginDescriptorImpl);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl7 = false;
            if (!DynamicPlugins.allowLoadUnloadWithoutRestart$default(it, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        if (list2.isEmpty()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(list2){
            final /* synthetic */ List $descriptorsToReload;

            public void afterVfsChange() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ prepareChange.2 this$0;

                    public final void run() {
                        boolean bl = false;
                        List reloaded2 = new ArrayList<E>();
                        boolean bl2 = false;
                        List unloadFailed = new ArrayList<E>();
                        for (IdeaPluginDescriptorImpl pluginDescriptor : this.this$0.$descriptorsToReload) {
                            if (!DynamicPlugins.unloadPlugin(pluginDescriptor, new DynamicPlugins.UnloadPluginOptions(false, true, false, false, true, false, 45, null))) {
                                unloadFailed.add(pluginDescriptor.getName());
                                continue;
                            }
                            reloaded2.add(pluginDescriptor.getName());
                            DynamicPlugins.loadPlugin$default(pluginDescriptor, false, 2, null);
                        }
                        Collection collection = unloadFailed;
                        boolean bl3 = false;
                        if (!collection.isEmpty()) {
                            DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl("Failed to unload modified plugins: " + CollectionsKt.joinToString$default((Iterable)unloadFailed, null, null, null, (int)0, null, null, (int)63, null), NotificationType.INFORMATION, new AnAction("Restart"){

                                public void actionPerformed(@NotNull AnActionEvent e) {
                                    ApplicationManager.getApplication().restart();
                                }
                            });
                        } else {
                            collection = reloaded2;
                            bl3 = false;
                            if (!collection.isEmpty()) {
                                DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(CollectionsKt.joinToString$default((Iterable)reloaded2, null, null, null, (int)0, null, null, (int)63, null) + " reloaded successfully", NotificationType.INFORMATION, new AnAction[0]);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$descriptorsToReload = $captured_local_variable$0;
            }
        };
    }

    private final IdeaPluginDescriptorImpl findPluginByPath(String path) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        block2: {
            if (!FileUtil.isAncestor((String)PathManager.getPluginsPath(), (String)path, (boolean)false)) {
                return null;
            }
            IdeaPluginDescriptor[] $this$firstOrNull$iv = PluginManager.getPlugins();
            boolean $i$f$firstOrNull = false;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = $this$firstOrNull$iv;
            int n = ideaPluginDescriptorArray.length;
            for (int j = 0; j < n; ++j) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it = element$iv = ideaPluginDescriptorArray[j];
                boolean bl = false;
                if (!FileUtil.isAncestor((String)((Object)it.getPluginPath().toAbsolutePath()).toString(), (String)path, (boolean)false)) continue;
                ideaPluginDescriptor = element$iv;
                break block2;
            }
            ideaPluginDescriptor = null;
        }
        return (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
    }

    public DynamicPluginVfsListener() {
        if (SystemProperties.is((String)"idea.auto.reload.plugins")) {
            String pluginsPath = PathManager.getPluginsPath();
            LocalFileSystem.getInstance().addRootToWatch(pluginsPath, true);
            VirtualFile pluginsRoot = LocalFileSystem.getInstance().findFileByPath(pluginsPath);
            if (pluginsRoot != null) {
                VfsUtilCore.processFilesRecursively((VirtualFile)pluginsRoot, (Processor)1.INSTANCE);
                RefreshQueue.getInstance().refresh(true, true, new Runnable(){

                    @Override
                    public final void run() {
                        initialRefreshDone = true;
                    }
                }, new VirtualFile[]{pluginsRoot});
            }
        }
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(DynamicPluginVfsListener.class);
    }

    public static final /* synthetic */ boolean access$getInitialRefreshDone$p(DynamicPluginVfsListener $this) {
        return $this.initialRefreshDone;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

