/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import gnu.trove.THashMap;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class DescriptorLoadingContext
implements AutoCloseable {
    private final Map<Path, FileSystem> openedFiles = new THashMap();
    final DescriptorListLoadingContext parentContext;
    final boolean isBundled;
    final boolean isEssential;
    final PathBasedJdomXIncluder.PathResolver<?> pathResolver;

    DescriptorLoadingContext(@NotNull DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        this.parentContext = parentContext;
        this.isBundled = isBundled;
        this.isEssential = isEssential;
        this.pathResolver = pathResolver;
    }

    @NotNull
    FileSystem open(@NotNull Path file2) throws IOException {
        FileSystem result2 = this.openedFiles.get(file2);
        if (result2 == null) {
            result2 = FileSystems.newFileSystem(file2, null);
            this.openedFiles.put(file2, result2);
        }
        return result2;
    }

    @Override
    public void close() {
        for (FileSystem file2 : this.openedFiles.values()) {
            try {
                file2.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public DescriptorLoadingContext copy(boolean isEssential) {
        return new DescriptorLoadingContext(this.parentContext, this.isBundled, isEssential, this.pathResolver);
    }
}

