/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DescriptorListLoadingContext
implements AutoCloseable {
    private static final boolean unitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
    static final int IS_PARALLEL = 1;
    static final int IGNORE_MISSING_INCLUDE = 2;
    static final int IGNORE_MISSING_SUB_DESCRIPTOR = 4;
    static final int CHECK_OPTIONAL_CONFIG_NAME_UNIQUENESS = 8;
    static final Logger LOG = PluginManagerCore.getLogger();
    @NotNull
    private final ExecutorService executorService;
    private final ConcurrentLinkedQueue<SafeJdomFactory[]> toDispose;
    private final Supplier<PluginXmlFactory> xmlFactorySupplier;
    @Nullable
    private final ThreadLocal<PluginXmlFactory[]> threadLocalXmlFactory;
    private final int maxThreads;
    @NotNull
    final PluginLoadingResult result;
    final Set<PluginId> disabledPlugins;
    private volatile String defaultVersion;
    final boolean ignoreMissingInclude;
    final boolean ignoreMissingSubDescriptor;
    boolean usePluginClassLoader = !PluginManagerCore.isUnitTestMode || unitTestWithBundledPlugins;
    private final Map<String, PluginId> optionalConfigNames;
    private final Path bundledPluginsPath;
    final boolean loadBundledPlugins;

    @NotNull
    public static DescriptorListLoadingContext createSingleDescriptorContext(@NotNull Set<PluginId> disabledPlugins) {
        return new DescriptorListLoadingContext(4, disabledPlugins, PluginManagerCore.createLoadingResult(null));
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result2) {
        this(flags, disabledPlugins, result2, null);
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result2, @Nullable Path bundledPluginsPath) {
        this.result = result2;
        this.disabledPlugins = disabledPlugins;
        this.ignoreMissingInclude = (flags & 2) == 2;
        this.ignoreMissingSubDescriptor = (flags & 4) == 4;
        this.optionalConfigNames = (flags & 8) == 8 ? new ConcurrentHashMap() : null;
        int n = this.maxThreads = (flags & 1) == 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.maxThreads > 1) {
            this.executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PluginManager Loader", (int)this.maxThreads, (boolean)false);
            this.toDispose = new ConcurrentLinkedQueue();
            this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> {
                PluginXmlFactory factory2 = new PluginXmlFactory();
                PluginXmlFactory[] ref = new PluginXmlFactory[]{factory2};
                this.toDispose.add((SafeJdomFactory[])ref);
                return ref;
            });
            this.xmlFactorySupplier = () -> this.threadLocalXmlFactory.get()[0];
        } else {
            this.executorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.toDispose = null;
            this.threadLocalXmlFactory = null;
            PluginXmlFactory factory2 = new PluginXmlFactory();
            this.xmlFactorySupplier = () -> factory2;
        }
        this.loadBundledPlugins = bundledPluginsPath != null || !PluginManagerCore.isUnitTestMode;
        this.bundledPluginsPath = bundledPluginsPath;
    }

    @NotNull
    Path getBundledPluginsPath() {
        return this.bundledPluginsPath == null ? Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]) : this.bundledPluginsPath;
    }

    boolean isPluginDisabled(@NotNull PluginId id2) {
        return id2 != PluginManagerCore.CORE_ID && this.disabledPlugins.contains(id2);
    }

    @NotNull
    ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NotNull
    SafeJdomFactory getXmlFactory() {
        return (SafeJdomFactory)this.xmlFactorySupplier.get();
    }

    @Override
    public void close() {
        if (this.threadLocalXmlFactory == null) {
            return;
        }
        if (this.maxThreads <= 1) {
            this.threadLocalXmlFactory.remove();
            return;
        }
        this.executorService.execute(() -> {
            for (SafeJdomFactory[] ref : this.toDispose) {
                ref[0] = null;
            }
        });
        this.executorService.shutdown();
    }

    @NotNull
    public String internString(@NotNull String string) {
        return this.xmlFactorySupplier.get().intern(string);
    }

    @NotNull
    public String getDefaultVersion() {
        String result2 = this.defaultVersion;
        if (result2 == null) {
            this.defaultVersion = result2 = this.result.productBuildNumber.get().asStringWithoutProductCode();
        }
        return result2;
    }

    @NotNull
    public DateFormat getDateParser() {
        return this.xmlFactorySupplier.get().releaseDateFormat;
    }

    @NotNull
    public List<String> getVisitedFiles() {
        return this.xmlFactorySupplier.get().visitedFiles;
    }

    boolean checkOptionalConfigShortName(@NotNull String configFile, @NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor rootDescriptor) {
        PluginId pluginId = descriptor2.getPluginId();
        if (pluginId == null) {
            return false;
        }
        Map<String, PluginId> configNames = this.optionalConfigNames;
        if (configNames == null) {
            return false;
        }
        PluginId oldPluginId = configNames.put(configFile, pluginId);
        if (oldPluginId == null || oldPluginId.equals(pluginId)) {
            return false;
        }
        LOG.error("Optional config file with name '" + configFile + "' already registered by '" + oldPluginId + "'. Please rename to ensure that lookup in the classloader by short name returns correct optional config. Current plugin: '" + rootDescriptor + "'. ");
        return true;
    }
}

