/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
public final class CustomPluginRepositoryService {
    private Collection<IdeaPluginDescriptor> myCustomRepositoryPluginsList;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoryPluginsMap;
    private final Object myRepositoriesLock = new Object();
    private static final Logger LOG = Logger.getInstance(CustomPluginRepositoryService.class);

    public static CustomPluginRepositoryService getInstance() {
        return (CustomPluginRepositoryService)ServiceManager.getService(CustomPluginRepositoryService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, List<IdeaPluginDescriptor>> getCustomRepositoryPluginMap() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myCustomRepositoryPluginsMap != null) {
                return this.myCustomRepositoryPluginsMap;
            }
        }
        HashMap<PluginId, IdeaPluginDescriptor> latestCustomPluginsAsMap = new HashMap<PluginId, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> customRepositoryPluginsMap = new HashMap<String, List<IdeaPluginDescriptor>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                if (host == null) continue;
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null);
                for (IdeaPluginDescriptor descriptor2 : descriptors) {
                    PluginId pluginId = descriptor2.getPluginId();
                    IdeaPluginDescriptor savedDescriptor = (IdeaPluginDescriptor)latestCustomPluginsAsMap.get(pluginId);
                    if (savedDescriptor == null) {
                        latestCustomPluginsAsMap.put(pluginId, descriptor2);
                        continue;
                    }
                    if (StringUtil.compareVersionNumbers((String)descriptor2.getVersion(), (String)savedDescriptor.getVersion()) <= 0) continue;
                    latestCustomPluginsAsMap.put(pluginId, descriptor2);
                }
                customRepositoryPluginsMap.put(host, descriptors);
            }
            catch (IOException e) {
                LOG.info(host, (Throwable)e);
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> UpdateChecker.updateDescriptorsForInstalledPlugins(InstalledPluginsState.getInstance()));
        Object object2 = this.myRepositoriesLock;
        synchronized (object2) {
            if (this.myCustomRepositoryPluginsMap == null) {
                this.myCustomRepositoryPluginsMap = customRepositoryPluginsMap;
                this.myCustomRepositoryPluginsList = latestCustomPluginsAsMap.values();
            }
            return this.myCustomRepositoryPluginsMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<IdeaPluginDescriptor> getCustomRepositoryPlugins() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            if (this.myCustomRepositoryPluginsList != null) {
                return this.myCustomRepositoryPluginsList;
            }
        }
        this.getCustomRepositoryPluginMap();
        return this.myCustomRepositoryPluginsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myCustomRepositoryPluginsList = null;
            this.myCustomRepositoryPluginsMap = null;
        }
    }
}

