/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassPathXmlPathResolver
implements PathBasedJdomXIncluder.PathResolver<String> {
    private final ClassLoader classLoader;

    ClassPathXmlPathResolver(@NotNull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @NotNull
    public List<String> createNewStack(@Nullable Path base) {
        ArrayList<String> stack = new ArrayList<String>(2);
        stack.add("META-INF");
        return stack;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull List<String> bases, @NotNull String relativePath, @Nullable String base, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        InputStream stream;
        String path;
        if (relativePath.charAt(0) != '/') {
            if (base == null) {
                base = bases.get(bases.size() - 1);
            }
            if (relativePath.startsWith("./")) {
                PluginManagerCore.getLogger().error("Do not use prefix ./: " + relativePath);
                relativePath = relativePath.substring(2);
            }
            path = base + "/" + relativePath;
            if (relativePath.indexOf(47, 1) > 0) {
                bases.add(PathUtil.getParentPath((String)path));
            }
        } else {
            path = relativePath.substring(1);
        }
        if ((stream = this.classLoader.getResourceAsStream(path)) == null) {
            throw new NoSuchFileException(relativePath);
        }
        return JDOMUtil.load((InputStream)stream, (SafeJdomFactory)jdomFactory);
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull Path basePath, @NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        String path;
        if (relativePath.charAt(0) == '/') {
            path = relativePath.substring(1);
        } else {
            if (relativePath.startsWith("./")) {
                PluginManagerCore.getLogger().error("Do not use prefix ./: " + relativePath);
                relativePath = relativePath.substring(2);
            }
            path = "META-INF/" + relativePath;
        }
        InputStream stream = this.classLoader.getResourceAsStream(path);
        if (stream == null) {
            throw new NoSuchFileException(relativePath);
        }
        return JDOMUtil.load((InputStream)stream, (SafeJdomFactory)jdomFactory);
    }
}

