/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class CachingSemiGraph<Node>
implements InboundSemiGraph<Node> {
    private final List<Node> nodes;
    private final Map<Node, List<Node>> in;

    CachingSemiGraph(@NotNull List<Node> nodes, @NotNull Function<Node, List<Node>> inSupplier) {
        this.nodes = nodes;
        this.in = new HashMap<Node, List<Node>>(nodes.size());
        for (Node node : nodes) {
            List<Node> list2 = inSupplier.apply(node);
            if (list2.isEmpty()) continue;
            this.in.put(node, list2);
        }
    }

    @NotNull
    public Collection<Node> getNodes() {
        return this.nodes;
    }

    @NotNull
    public Iterator<Node> getIn(@NotNull Node n) {
        List<Node> inNodes = this.in.get(n);
        return inNodes == null ? Collections.emptyIterator() : inNodes.iterator();
    }

    @NotNull
    public List<Node> getInList(@NotNull Node n) {
        List<Node> inNodes = this.in.get(n);
        return inNodes == null ? Collections.emptyList() : inNodes;
    }
}

