/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BasePathResolver
implements PathBasedJdomXIncluder.PathResolver<Path> {
    BasePathResolver() {
    }

    @Override
    @NotNull
    public List<Path> createNewStack(@Nullable Path base) {
        ArrayList<Path> stack = new ArrayList<Path>(2);
        if (base != null) {
            stack.add(base);
        }
        return stack;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull List<Path> bases, @NotNull String relativePath, @Nullable String base, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        Path basePath = base == null ? bases.get(bases.size() - 1) : Paths.get(base, new String[0]);
        Path path = basePath == null ? Paths.get(relativePath, new String[0]) : basePath.resolve(relativePath);
        Element element2 = JDOMUtil.load((Path)path, (SafeJdomFactory)jdomFactory);
        if (basePath == null) {
            bases.add(path.getParent());
        } else {
            Path parent = path.getParent();
            if (!parent.equals(basePath)) {
                bases.add(parent);
                assert (!bases.contains(path)) : "Circular XInclude Reference to " + path;
            }
        }
        return element2;
    }

    @Override
    @NotNull
    public Element resolvePath(@NotNull Path basePath, @NotNull String relativePath, @NotNull SafeJdomFactory jdomFactory) throws IOException, JDOMException {
        return JDOMUtil.load((Path)basePath.resolve(relativePath), (SafeJdomFactory)jdomFactory);
    }
}

