/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class ActivateNavigationBarAction
extends AnAction
implements DumbAware {
    ActivateNavigationBarAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || !UISettings.getInstance().getShowNavigationBar()) {
            return;
        }
        IdeRootPane ideRootPane = ((WindowManagerImpl)WindowManager.getInstance()).getProjectFrameRootPane(project);
        if (ideRootPane == null) {
            return;
        }
        IdeRootPaneNorthExtension navBar = ideRootPane.findByName("NavBar");
        if (navBar == null) {
            return;
        }
        JComponent component2 = navBar.getComponent();
        if (component2 instanceof NavBarPanel) {
            ((NavBarPanel)component2).rebuildAndSelectTail(true);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        UISettings settings = UISettings.getInstance();
        boolean enabled = project != null && settings.getShowNavigationBar() && !settings.getPresentationMode();
        e.getPresentation().setEnabled(enabled);
    }
}

