/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class FilePathRelativeToProjectRootMacro
extends Macro {
    @Override
    @NotNull
    public String getName() {
        return "FilePathRelativeToProjectRoot";
    }

    @Override
    @NotNull
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.path.relative.to.root", (Object[])new Object[0]);
    }

    @Override
    public String expand(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file2 == null) {
            return null;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(file2);
        if (contentRoot == null) {
            return null;
        }
        return FileUtil.getRelativePath((File)FilePathRelativeToProjectRootMacro.getIOFile(contentRoot), (File)FilePathRelativeToProjectRootMacro.getIOFile(file2));
    }
}

