/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorMacro
extends Macro {
    private final String myName;
    private final String myDescription;

    public EditorMacro(@NotNull String name, @NotNull String description) {
        this.myName = name;
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public final String expand(@NotNull DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            return this.expand(editor);
        }
        return null;
    }

    protected static String getColumnNumber(Editor editor, LogicalPosition pos) {
        if (EditorUtil.inVirtualSpace(editor, pos)) {
            return String.valueOf(pos.column + 1);
        }
        int offset = editor.logicalPositionToOffset(pos);
        int lineStart = editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(offset));
        return String.valueOf(offset - lineStart + 1);
    }

    @Nullable
    protected abstract String expand(Editor var1);
}

