/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorInfoImpl;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditPositionWidget
extends PositionPanel
implements LightEditorListener {
    private final LightEditorManager myEditorManager;
    @Nullable
    private Editor myEditor;

    public LightEditPositionWidget(@NotNull LightEditorManager editorManager) {
        super(LightEditUtil.getProject());
        this.myEditorManager = editorManager;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        this.myEditorManager.addListener((LightEditorListener)this);
    }

    @Override
    public boolean isOurEditor(Editor editor) {
        return editor != null && this.myEditor == editor && editor.getComponent().isShowing();
    }

    public void afterSelect(@Nullable LightEditorInfo editorInfo) {
        this.myEditor = LightEditorInfoImpl.getEditor(editorInfo);
    }

    @Override
    @Nullable
    protected Editor getEditor() {
        return this.myEditor;
    }
}

