/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.menuBar;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecentFileActionGroup
extends ActionGroup
implements DumbAware,
AlwaysVisibleActionGroup {
    RecentFileActionGroup() {
        super(ApplicationBundle.messagePointer((String)"light.edit.action.recentFile.text", (Object[])new Object[0]), true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project;
        Project project2 = project = e != null ? e.getProject() : null;
        if (!LightEdit.owns((Project)project)) {
            return AnAction.EMPTY_ARRAY;
        }
        List<VirtualFile> recentFiles = RecentFileActionGroup.getRecentFiles(project);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.addAll(ContainerUtil.map(recentFiles, file2 -> new OpenFileAction((VirtualFile)file2)));
        List<AnAction> recentProjectsActions = RecentProjectListActionProvider.getInstance().getActions(false);
        if (!recentProjectsActions.isEmpty()) {
            if (!actions.isEmpty()) {
                actions.add(Separator.create());
            }
            actions.addAll(recentProjectsActions);
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    @NotNull
    private static List<VirtualFile> getRecentFiles(@NotNull Project project) {
        List<VirtualFile> historyFiles = EditorHistoryManager.getInstance(project).getFileList();
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>(historyFiles);
        result2.removeAll(Arrays.asList(FileEditorManager.getInstance((Project)project).getOpenFiles()));
        return new ArrayList<VirtualFile>(result2);
    }

    private static class OpenFileAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final VirtualFile myFile;

        private OpenFileAction(@NotNull VirtualFile file2) {
            this.myFile = file2;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            presentation2.setText(this.myFile.getName());
            presentation2.setIcon(IconUtil.getIcon((VirtualFile)this.myFile, (int)2, (Project)e.getProject()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project != null) {
                LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project, this.myFile);
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
                new OpenFileDescriptor(project, this.myFile).navigate(true);
            }
        }
    }
}

