/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.menuBar;

import com.intellij.ide.lightEdit.actions.LightEditAssociateFileTypesAction;
import com.intellij.ide.lightEdit.actions.LightEditExitAction;
import com.intellij.ide.lightEdit.actions.LightEditNewFileAction;
import com.intellij.ide.lightEdit.actions.LightEditOpenFileInProjectAction;
import com.intellij.ide.lightEdit.actions.LightEditSaveAsAction;
import com.intellij.ide.lightEdit.menuBar.RecentFileActionGroup;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditMenuBar
extends IdeMenuBar {
    @Override
    @NotNull
    public ActionGroup getMainMenuActionGroup() {
        DefaultActionGroup topGroup = new DefaultActionGroup();
        topGroup.add((AnAction)LightEditMenuBar.createActionGroup(ActionsBundle.message((String)"group.FileMenu.text", (Object[])new Object[0]), new AnAction[]{new LightEditOpenFileInProjectAction(), Separator.create(), new LightEditNewFileAction(), Separator.create(), LightEditMenuBar.standardAction("OpenFile"), new RecentFileActionGroup(), Separator.create(), new LightEditSaveAsAction(), LightEditMenuBar.standardAction("SaveAll"), Separator.create(), new LightEditExitAction()}));
        topGroup.add((AnAction)LightEditMenuBar.createActionGroup(ActionsBundle.message((String)"group.EditMenu.text", (Object[])new Object[0]), new AnAction[]{LightEditMenuBar.standardAction("$Undo"), LightEditMenuBar.standardAction("$Redo"), Separator.create(), LightEditMenuBar.standardAction("$Cut"), LightEditMenuBar.standardAction("$Copy"), LightEditMenuBar.standardAction("$Paste"), LightEditMenuBar.standardAction("$Delete"), Separator.create(), LightEditMenuBar.standardAction("EditorSelectWord"), LightEditMenuBar.standardAction("EditorUnSelectWord"), LightEditMenuBar.standardAction("$SelectAll")}));
        ObjectUtils.consumeIfNotNull((Object)LightEditMenuBar.createToolActionGroup(), toolGroup -> topGroup.add((AnAction)toolGroup));
        topGroup.add((AnAction)LightEditMenuBar.createActionGroup(ActionsBundle.message((String)"group.ViewMenu.text", (Object[])new Object[0]), LightEditMenuBar.standardAction("EditorToggleShowWhitespaces"), LightEditMenuBar.standardAction("EditorToggleShowLineNumbers")));
        topGroup.add((AnAction)LightEditMenuBar.createActionGroup(ActionsBundle.message((String)"group.HelpMenu.text", (Object[])new Object[0]), LightEditMenuBar.standardAction("HelpTopics"), LightEditMenuBar.standardAction("About")));
        return topGroup;
    }

    @NotNull
    private static ActionGroup createActionGroup(@NotNull String title, AnAction ... actions) {
        return new DefaultActionGroup(title, Arrays.asList(actions));
    }

    @Nullable
    private static ActionGroup createToolActionGroup() {
        if (LightEditAssociateFileTypesAction.isAvailable()) {
            return LightEditMenuBar.createActionGroup(ActionsBundle.message((String)"group.ToolsMenu.text", (Object[])new Object[0]), new AnAction[]{new LightEditAssociateFileTypesAction()});
        }
        return null;
    }

    private static AnAction standardAction(@NotNull String id2) {
        return ActionManager.getInstance().getAction(id2);
    }
}

