/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.intentions.openInProject.ProjectRootSearchUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditOpenInProjectIntention
implements IntentionAction,
LightEditCompatible,
DumbAware {
    public @IntentionName @NotNull String getText() {
        return ApplicationBundle.message((String)"light.edit.open.in.project.intention", (Object[])new Object[0]);
    }

    public @IntentionFamilyName @NotNull String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return LightEdit.owns((Project)project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        LightEditOpenInProjectIntention.performOn(file2.getVirtualFile());
    }

    public static void performOn(@NotNull VirtualFile currentFile) throws IncorrectOperationException {
        LightEditorInfo editorInfo = ((LightEditorManagerImpl)LightEditService.getInstance().getEditorManager()).findOpen(currentFile);
        if (editorInfo != null) {
            Project openProject2 = LightEditOpenInProjectIntention.findOpenProject(currentFile);
            if (openProject2 != null) {
                LightEditFeatureUsagesUtil.logOpenFileInProject(LightEditFeatureUsagesUtil.ProjectStatus.Open);
            } else {
                VirtualFile projectRoot = ProjectRootSearchUtil.findProjectRoot(currentFile);
                if (projectRoot != null) {
                    openProject2 = PlatformProjectOpenProcessor.getInstance().openProjectAndFile(projectRoot.toNioPath(), -1, -1, false);
                }
            }
            if (openProject2 != null) {
                ((LightEditServiceImpl)LightEditService.getInstance()).closeEditor(editorInfo);
                OpenFileAction.openFile(currentFile, openProject2);
            }
        }
    }

    @Nullable
    private static Project findOpenProject(@NotNull VirtualFile file2) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file2)) continue;
            return project;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

