/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditorInfoImpl
implements LightEditorInfo {
    private final FileEditorProvider myProvider;
    private final FileEditor myFileEditor;
    private final VirtualFile myFile;

    LightEditorInfoImpl(@NotNull FileEditorProvider provider, @NotNull FileEditor fileEditor, @NotNull VirtualFile file2) {
        this.myProvider = provider;
        this.myFileEditor = fileEditor;
        this.myFile = file2;
    }

    @NotNull
    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public boolean isUnsaved() {
        if (this.isNew()) {
            return true;
        }
        return FileDocumentManager.getInstance().isFileModified(this.myFile);
    }

    public boolean isNew() {
        return this.myFile instanceof LightVirtualFile;
    }

    public void disposeEditor() {
        this.myProvider.disposeEditor(this.myFileEditor);
    }

    @Nullable
    public static Editor getEditor(@Nullable LightEditorInfo editorInfo) {
        return LightEditorInfoImpl.getEditor(editorInfo != null ? editorInfo.getFileEditor() : null);
    }

    @Nullable
    public static Editor getEditor(@Nullable FileEditor fileEditor) {
        TextEditor textEditor = (TextEditor)ObjectUtils.tryCast((Object)fileEditor, TextEditor.class);
        return textEditor != null ? textEditor.getEditor() : null;
    }

    @NotNull
    public FileEditorProvider getProvider() {
        return this.myProvider;
    }
}

