/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.impl.SelectProjectOpenProcessorDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.JBProtocolOpenProjectCommand;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.FocusUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class ProjectUtil {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    private static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    private static final String MODE_ATTACH = "attach";
    private static final String MODE_REPLACE = "replace";
    private static final String MODE_NEW = "new";

    private ProjectUtil() {
    }

    @Deprecated
    public static void updateLastProjectLocation(@NotNull String projectFilePath) {
        ProjectUtil.updateLastProjectLocation(Paths.get(projectFilePath, new String[0]));
    }

    public static void updateLastProjectLocation(@NotNull Path lastProjectLocation) {
        if (Files.isRegularFile(lastProjectLocation, new LinkOption[0])) {
            lastProjectLocation = lastProjectLocation.getParent();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParent()) == null) {
            return;
        }
        String path = lastProjectLocation.toString();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)path));
    }

    @Deprecated
    public static boolean closeAndDispose(@NotNull Project project) {
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    public static Project openOrImport(@NotNull Path path, Project projectToClose, boolean forceOpenInNewFrame) {
        return ProjectUtil.openOrImport(path, OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    public static Project openOrImport(@NotNull Path path) {
        return ProjectUtil.openOrImport(path, new OpenProjectTask());
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        return ProjectUtil.openOrImport(Paths.get(path, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Project openOrImport(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Project project;
        Object virtualFile2;
        Project existing;
        if (!options2.getForceOpenInNewFrame() && (existing = ProjectUtil.findAndFocusExistingProjectForPath(file2)) != null) {
            return existing;
        }
        NullableLazyValue lazyVirtualFile = NullableLazyValue.createValue(() -> ProjectUtil.getFileAndRefresh(file2));
        for (Object provider : ProjectOpenProcessor.EXTENSION_POINT_NAME.getIterable()) {
            if (!provider.isStrongProjectInfoHolder()) continue;
            virtualFile2 = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile2 == null) {
                return null;
            }
            if (!provider.canOpenProject((VirtualFile)virtualFile2)) continue;
            return ProjectUtil.chooseProcessorAndOpen(Collections.singletonList(provider), (VirtualFile)virtualFile2, options2);
        }
        if (ProjectUtil.isValidProjectPath(file2)) {
            return ProjectManagerEx.getInstanceEx().openProject(file2, options2.withRunConfigurators());
        }
        if (options2.checkDirectoryForFileBasedProjects && Files.isDirectory(file2, new LinkOption[0])) {
            try {
                Object provider;
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file2);
                provider = null;
                try {
                    for (Path child2 : directoryStream) {
                        String childPath = child2.toString();
                        if (!childPath.endsWith(".ipr")) continue;
                        Project project2 = ProjectUtil.openProject(Paths.get(childPath, new String[0]), options2);
                        return project2;
                    }
                }
                catch (Throwable virtualFile2) {
                    provider = virtualFile2;
                    throw virtualFile2;
                }
                finally {
                    if (directoryStream != null) {
                        if (provider != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)provider).addSuppressed(throwable);
                            }
                        } else {
                            directoryStream.close();
                        }
                    }
                }
            }
            catch (IOException directoryStream) {
                // empty catch block
            }
        }
        SmartList processors = new SmartList();
        ProjectOpenProcessor.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> ProjectUtil.lambda$openOrImport$1(file2, (List)processors, lazyVirtualFile, arg_0));
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1 && processors.get(0) instanceof PlatformProjectOpenProcessor) {
            project = ProjectManagerEx.getInstanceEx().openProject(file2, options2.asNewProjectAndRunConfigurators().withBeforeOpenCallback(p -> {
                p.putUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR, (Object)Boolean.TRUE);
                return true;
            }));
        } else {
            virtualFile2 = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile2 == null) {
                return null;
            }
            project = ProjectUtil.chooseProcessorAndOpen((List<ProjectOpenProcessor>)processors, (VirtualFile)virtualFile2, options2);
        }
        if (project == null) {
            return null;
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed()));
        return project;
    }

    @Nullable
    private static Project chooseProcessorAndOpen(@NotNull List<ProjectOpenProcessor> processors, @NotNull VirtualFile virtualFile, @NotNull OpenProjectTask options2) {
        ProjectOpenProcessor processor2;
        if (processors.size() == 1) {
            processor2 = processors.get(0);
        } else {
            processors.removeIf(it -> it instanceof PlatformProjectOpenProcessor);
            if (processors.size() == 1) {
                processor2 = processors.get(0);
            } else {
                Ref ref = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)new SelectProjectOpenProcessorDialog(processors, virtualFile).showAndGetChoice()));
                processor2 = (ProjectOpenProcessor)ref.get();
                if (processor2 == null) {
                    return null;
                }
            }
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)processor2.doOpenProject(virtualFile, options2.getProjectToClose(), options2.getForceOpenInNewFrame())));
        return (Project)result2.get();
    }

    @ApiStatus.Internal
    @Nullable
    public static VirtualFile getFileAndRefresh(@NotNull Path file2) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file2.toString()));
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        virtualFile.refresh(false, false);
        return virtualFile;
    }

    @Nullable
    public static Project openProject(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        return ProjectUtil.openProject(Paths.get(path, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    @Nullable
    public static Project openProject(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Path dir;
        BasicFileAttributes fileAttributes = PathKt.basicAttributesIfExists((Path)file2);
        if (fileAttributes == null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{file2.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(file2);
        if (existing != null) {
            return existing;
        }
        if (ProjectUtil.isRemotePath(file2.toString()) && !RecentProjectsManager.getInstance().hasPath(FileUtil.toSystemIndependentName((String)file2.toString())) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        String pathFromJBCommand = JetBrainsProtocolHandler.getMainParameter();
        if (pathFromJBCommand != null && file2.equals(JBProtocolOpenProjectCommand.toPath(pathFromJBCommand)) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.open.file.from.untrusted.source", "title.open.file.from.untrusted.source")) {
            return null;
        }
        if (fileAttributes.isDirectory() && !Files.isDirectory(dir = file2.resolve(".idea"), new LinkOption[0])) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        try {
            return ProjectManagerEx.getInstanceEx().openProject(file2, options2);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon2 = Messages.getWarningIcon();
        String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
        return (window == null ? Messages.showYesNoDialog((String)message, (String)title, (Icon)icon2) : Messages.showYesNoDialog((Component)window, (String)message, (String)title, (Icon)icon2)) == 0;
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        return path.contains("://") || path.contains("\\\\");
    }

    @NotNull
    public static @NotNull Project @NotNull [] getOpenProjects() {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        return projectManager == null ? new Project[]{} : projectManager.getOpenProjects();
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull Path file2) {
        Project[] openProjects = ProjectUtil.getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        for (Project project : openProjects) {
            if (!ProjectUtil.isSameProject(file2, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                LifecycleUsageTriggerCollector.onProjectFrameSelected(exitCode);
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            LifecycleUsageTriggerCollector.onProjectFrameSelected(exitCode);
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static int confirmOpenOrAttachProject() {
        int returnValue;
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        int exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.or.attach", (Object[])new Object[0]), (String)IdeBundle.message((String)"prompt.open.project.or.attach.title", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"prompt.open.project.or.attach.button.this.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.new.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.attach", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)(MODE_NEW.equals(mode) ? 1 : (MODE_REPLACE.equals(mode) ? 0 : (MODE_ATTACH.equals(mode) ? 2 : 0))), (Icon)Messages.getQuestionIcon());
        int n = exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (returnValue = exitCode == 2 ? 2 : -1));
        if (returnValue != -1) {
            LifecycleUsageTriggerCollector.onProjectFrameSelected(returnValue);
        }
        return returnValue;
    }

    @Deprecated
    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project) {
        return projectFilePath != null && ProjectUtil.isSameProject(Paths.get(projectFilePath, new String[0]), project);
    }

    public static boolean isSameProject(@NotNull Path projectFile, @NotNull Project project) {
        IProjectStore projectStore = ProjectKt.getStateStore(project);
        Path existingBaseDirPath = projectStore.getProjectBasePath();
        if (existingBaseDirPath.getFileSystem() != projectFile.getFileSystem()) {
            return false;
        }
        if (Files.isDirectory(projectFile, new LinkOption[0])) {
            return FileUtil.pathsEqual((String)projectFile.toString(), (String)existingBaseDirPath.toString());
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)projectFile.toString()), (String)projectStore.getProjectFilePath());
        }
        Path parent = projectFile.getParent();
        if (parent == null) {
            return false;
        }
        Path parentFileName = parent.getFileName();
        if (parentFileName != null && parentFileName.toString().equals(".idea")) {
            return (parent = parent.getParent()) != null && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
        }
        return projectFile.getFileName().toString().endsWith(".ipr") && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
    }

    public static void focusProjectWindow(@Nullable Project project, boolean executeIfAppInactive) {
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (frame == null) {
            return;
        }
        Component mostRecentFocusOwner = frame.getMostRecentFocusOwner();
        if (executeIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(project));
            frame.toFront();
            if (!SystemInfo.isMac && !frame.isAutoRequestFocus()) {
                if (mostRecentFocusOwner != null) {
                    IdeFocusManager.getInstance((Project)project).requestFocus(mostRecentFocusOwner, true);
                } else {
                    LOG.warn("frame.getMostRecentFocusOwner() is null");
                }
            }
        } else if (mostRecentFocusOwner != null) {
            IdeFocusManager.getInstance((Project)project).requestFocusInProject(mostRecentFocusOwner, project);
        } else {
            Component defaultFocusComponentInPanel = FocusUtil.getDefaultComponentInPanel((Component)frame.getFocusCycleRootAncestor());
            if (defaultFocusComponentInPanel != null) {
                IdeFocusManager.getInstance((Project)project).requestFocusInProject(defaultFocusComponentInPanel, project);
            }
        }
    }

    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (Strings.isNotEmpty((String)defaultDirectory)) {
            return defaultDirectory.replace('/', File.separatorChar);
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion() || PlatformUtils.isAppCode()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        return userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }

    @Nullable
    public static Project tryOpenFileList(@Nullable Project project, @NotNull List<? extends File> list2, String location) {
        Project result2 = null;
        for (File file2 : list2) {
            result2 = ProjectUtil.openOrImport(file2.toPath().toAbsolutePath(), OpenProjectTask.withProjectToClose(project, true));
            if (result2 == null) continue;
            LOG.debug(location + ": load project from ", new Object[]{file2});
            return result2;
        }
        for (File file3 : list2) {
            Project opened;
            if (!file3.exists()) continue;
            LOG.debug(location + ": open file ", new Object[]{file3});
            String path = file3.getAbsolutePath();
            if (project != null) {
                OpenFileAction.openFile(path, project);
                result2 = project;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (opened = processor2.openProjectAndFile(file3.toPath(), -1, -1, false)) == null || result2 != null) continue;
            result2 = opened;
        }
        return result2;
    }

    public static boolean isValidProjectPath(@NotNull Path file2) {
        return Files.isDirectory(file2.resolve(".idea"), new LinkOption[0]) || Strings.endsWith((CharSequence)file2.toString(), (CharSequence)".ipr") && Files.isRegularFile(file2, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$openOrImport$1(Path file2, List processors, NullableLazyValue lazyVirtualFile, ProjectOpenProcessor processor2) {
        if (processor2 instanceof PlatformProjectOpenProcessor) {
            if (Files.isDirectory(file2, new LinkOption[0])) {
                processors.add(processor2);
            }
        } else {
            VirtualFile virtualFile = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile != null && processor2.canOpenProject(virtualFile)) {
                processors.add(processor2);
            }
        }
    }
}

