/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataValidator;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.impl.dataRules.CopyProviderRule;
import com.intellij.ide.impl.dataRules.CutProviderRule;
import com.intellij.ide.impl.dataRules.FileEditorRule;
import com.intellij.ide.impl.dataRules.FileTextRule;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.impl.dataRules.InactiveEditorRule;
import com.intellij.ide.impl.dataRules.NavigatableArrayRule;
import com.intellij.ide.impl.dataRules.PasteProviderRule;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataManagerImpl
extends DataManager {
    private static final Logger LOG = Logger.getInstance(DataManagerImpl.class);
    private final ConcurrentMap<String, GetDataRule> myDataConstantToRuleMap = new ConcurrentHashMap<String, GetDataRule>();
    private final KeyedExtensionCollector<GetDataRule, String> myDataRuleCollector = new KeyedExtensionCollector(GetDataRule.EP_NAME);
    private static final Set<String> ourSafeKeys = ContainerUtil.set((Object[])new String[]{CommonDataKeys.PROJECT.getName(), CommonDataKeys.EDITOR.getName(), PlatformDataKeys.IS_MODAL_CONTEXT.getName(), PlatformDataKeys.CONTEXT_COMPONENT.getName(), PlatformDataKeys.MODALITY_STATE.getName()});

    public DataManagerImpl() {
        this.myDataConstantToRuleMap.put(PlatformDataKeys.COPY_PROVIDER.getName(), new CopyProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.CUT_PROVIDER.getName(), new CutProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.PASTE_PROVIDER.getName(), new PasteProviderRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_TEXT.getName(), new FileTextRule());
        this.myDataConstantToRuleMap.put(PlatformDataKeys.FILE_EDITOR.getName(), new FileEditorRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.NAVIGATABLE_ARRAY.getName(), new NavigatableArrayRule());
        this.myDataConstantToRuleMap.put(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getName(), new InactiveEditorRule());
    }

    @Nullable
    private Object getData(@NotNull String dataId, Component focusedComponent) {
        GetDataRule rule = this.getDataRule(dataId);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            for (Component c = focusedComponent; c != null; c = c.getParent()) {
                Object data2;
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
                if (dataProvider == null || (data2 = this.getDataFromProvider(dataProvider, dataId, null, rule)) == null) continue;
                Object object = data2;
                return object;
            }
        }
        return null;
    }

    @Nullable
    public Object getDataFromProvider(@NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds) {
        return this.getDataFromProvider(provider, dataId, alreadyComputedIds, this.getDataRule(dataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getDataFromProvider(@NotNull DataProvider provider, @NotNull String dataId, @Nullable Set<String> alreadyComputedIds, @Nullable GetDataRule dataRule) {
        ProgressManager.checkCanceled();
        if (alreadyComputedIds != null && alreadyComputedIds.contains(dataId)) {
            return null;
        }
        try {
            Object data2 = provider.getData(dataId);
            if (data2 != null) {
                Object object = DataManagerImpl.validated(data2, dataId, provider);
                return object;
            }
            if (dataRule != null) {
                THashSet ids = alreadyComputedIds == null ? new THashSet() : alreadyComputedIds;
                ids.add(dataId);
                data2 = dataRule.getData(arg_0 -> this.lambda$getDataFromProvider$0(provider, (Set)ids, arg_0));
                if (data2 != null) {
                    Object object = DataManagerImpl.validated(data2, dataId, provider);
                    return object;
                }
            }
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (alreadyComputedIds != null) {
                alreadyComputedIds.remove(dataId);
            }
        }
    }

    @Nullable
    public static DataProvider getDataProviderEx(Object component2) {
        DataProvider dataProvider = null;
        if (component2 instanceof DataProvider) {
            dataProvider = (DataProvider)component2;
        } else if (component2 instanceof TypeSafeDataProvider) {
            dataProvider = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)component2);
        } else if (component2 instanceof JComponent) {
            dataProvider = DataManagerImpl.getDataProvider((JComponent)((JComponent)component2));
        }
        return dataProvider;
    }

    @Nullable
    public GetDataRule getDataRule(@NotNull String dataId) {
        GetDataRule rule = this.getRuleFromMap(dataId);
        if (rule != null) {
            return rule;
        }
        GetDataRule plainRule = this.getRuleFromMap(AnActionEvent.uninjectedId((String)dataId));
        if (plainRule != null) {
            return dataProvider -> plainRule.getData(id2 -> dataProvider.getData(AnActionEvent.injectedId((String)id2)));
        }
        return null;
    }

    @Nullable
    private GetDataRule getRuleFromMap(@NotNull String dataId) {
        GetDataRule rule = (GetDataRule)this.myDataConstantToRuleMap.get(dataId);
        if (rule != null) {
            return rule;
        }
        return (GetDataRule)this.myDataRuleCollector.findSingle((Object)dataId);
    }

    @Nullable
    private static Object validated(@NotNull Object data2, @NotNull String dataId, @NotNull Object dataSource) {
        Object invalidData = DataValidator.findInvalidData(dataId, data2, dataSource);
        if (invalidData != null) {
            return null;
        }
        return data2;
    }

    @NotNull
    public DataContext getDataContext(Component component2) {
        return new MyDataContext(component2);
    }

    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (x < 0 || x >= component2.getWidth() || y < 0 || y >= component2.getHeight()) {
            throw new IllegalArgumentException("wrong point: x=" + x + "; y=" + y);
        }
        if (component2 instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component2;
            int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, x, y);
            return this.getDataContext(index != -1 ? tabbedPane.getComponentAt(index) : tabbedPane);
        }
        return this.getDataContext(component2);
    }

    @NotNull
    public DataContext getDataContext() {
        Component component2 = null;
        if (Registry.is((String)"actionSystem.getContextByRecentMouseEvent")) {
            component2 = SwingHelper.getComponentFromRecentMouseEvent();
        }
        return this.getDataContext(component2 != null ? component2 : DataManagerImpl.getFocusedComponent());
    }

    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise result2 = new AsyncPromise();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> result2.setResult((Object)this.getDataContext()), ModalityState.any());
        return result2;
    }

    @NotNull
    public DataContext getDataContextTest(Component component2) {
        DataContext dataContext = this.getDataContext(component2);
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            return dataContext;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Component focusedComponent = ((WindowManagerEx)windowManager).getFocusedComponent(project);
        if (focusedComponent != null) {
            dataContext = this.getDataContext(focusedComponent);
        }
        return dataContext;
    }

    @Nullable
    private static Component getFocusedComponent() {
        WindowManager windowManager = WindowManager.getInstance();
        if (!(windowManager instanceof WindowManagerEx)) {
            return null;
        }
        WindowManagerEx windowManagerEx = (WindowManagerEx)windowManager;
        Window activeWindow = windowManagerEx.getMostRecentFocusedWindow();
        if (activeWindow == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null && (activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            return null;
        }
        if (activeWindow instanceof FloatingDecorator) {
            boolean toolWindowIsNotFocused;
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            boolean bl = toolWindowIsNotFocused = windowManagerEx.getFocusedComponent(activeWindow) == null;
            if (toolWindowIsNotFocused && lastFocusedWindow != null) {
                activeWindow = lastFocusedWindow;
            }
        }
        Component focusedComponent = null;
        for (Window window = activeWindow; window != null && (focusedComponent = windowManagerEx.getFocusedComponent(window)) == null; window = window.getOwner()) {
        }
        if (focusedComponent == null) {
            focusedComponent = activeWindow;
        }
        return focusedComponent;
    }

    public <T> void saveInDataContext(DataContext dataContext, @NotNull Key<T> dataKey, @Nullable T data2) {
        if (dataContext instanceof UserDataHolder) {
            ((UserDataHolder)dataContext).putUserData(dataKey, data2);
        }
    }

    @Nullable
    public <T> T loadFromDataContext(@NotNull DataContext dataContext, @NotNull Key<T> dataKey) {
        return (T)(dataContext instanceof UserDataHolder ? ((UserDataHolder)dataContext).getUserData(dataKey) : null);
    }

    @Nullable
    public static Editor validateEditor(Editor editor) {
        JComponent jComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JComponent && (jComponent = (JComponent)focusOwner).getClientProperty("AuxEditorComponent") != null) {
            return null;
        }
        return editor;
    }

    private /* synthetic */ Object lambda$getDataFromProvider$0(DataProvider provider, Set ids, String id2) {
        return this.getDataFromProvider(provider, id2, ids);
    }

    @Deprecated
    public static class MyDataContext
    implements DataContext,
    UserDataHolder {
        private int myEventCount = -1;
        private final Reference<Component> myRef;
        private Map<Key<?>, Object> myUserData;
        private final Map<String, Object> myCachedData = ContainerUtil.createWeakValueMap();

        public MyDataContext(@Nullable Component component2) {
            this.myRef = component2 == null ? null : new WeakReference<Component>(component2);
        }

        public void setEventCount(int eventCount) {
            assert (ReflectionUtil.getCallerClass((int)3) == IdeKeyEventDispatcher.class) : "This method might be accessible from " + IdeKeyEventDispatcher.class.getName() + " only";
            this.myCachedData.clear();
            this.myEventCount = eventCount;
        }

        public Object getData(@NotNull String dataId) {
            Object answer;
            boolean cacheable;
            ProgressManager.checkCanceled();
            boolean bl = cacheable = Registry.is((String)"actionSystem.cache.data") || ourSafeKeys.contains(dataId);
            if (ApplicationManager.getApplication().isDispatchThread()) {
                int currentEventCount = IdeEventQueue.getInstance().getEventCount();
                if (this.myEventCount != -1 && this.myEventCount != currentEventCount) {
                    LOG.error("cannot share data context between Swing events; initial event count = " + this.myEventCount + "; current event count = " + currentEventCount);
                    cacheable = false;
                }
            }
            Object object = answer = cacheable ? this.myCachedData.get(dataId) : null;
            if (answer != null) {
                return answer != NullResult.INSTANCE ? answer : null;
            }
            answer = this.doGetData(dataId);
            if (cacheable && !(answer instanceof Stream)) {
                this.myCachedData.put(dataId, answer == null ? NullResult.INSTANCE : answer);
            }
            return answer;
        }

        @Nullable
        private Object doGetData(@NotNull String dataId) {
            Component component2 = (Component)SoftReference.dereference(this.myRef);
            if (PlatformDataKeys.IS_MODAL_CONTEXT.is(dataId)) {
                if (component2 == null) {
                    return null;
                }
                return IdeKeyEventDispatcher.isModalContext(component2);
            }
            if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
                return component2;
            }
            if (PlatformDataKeys.MODALITY_STATE.is(dataId)) {
                return component2 != null ? ModalityState.stateForComponent((Component)component2) : ModalityState.NON_MODAL;
            }
            Object data2 = this.calcData(dataId, component2);
            if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
                return DataManagerImpl.validateEditor((Editor)data2);
            }
            return data2;
        }

        protected Object calcData(@NotNull String dataId, Component component2) {
            return ((DataManagerImpl)DataManager.getInstance()).getData(dataId, component2);
        }

        @NonNls
        public String toString() {
            return "component=" + SoftReference.dereference(this.myRef);
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            return (T)this.getOrCreateMap().get(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            this.getOrCreateMap().put(key, value2);
        }

        @NotNull
        private Map<Key<?>, Object> getOrCreateMap() {
            Map userData = this.myUserData;
            if (userData == null) {
                this.myUserData = userData = ContainerUtil.createWeakValueMap();
            }
            return userData;
        }
    }

    private static final class NullResult {
        public static final NullResult INSTANCE = new NullResult();

        private NullResult() {
        }
    }
}

