/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.ide.highlighter.custom.CustomHighlighterColors;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CustomFileHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ourKeys = new HashMap<IElementType, TextAttributesKey>();
    private final SyntaxTable myTable;

    public CustomFileHighlighter(SyntaxTable table) {
        this.myTable = table;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        CustomFileTypeLexer customFileTypeLexer = new CustomFileTypeLexer(this.myTable, true);
        if (this.myTable.isHasStringEscapes()) {
            customFileTypeLexer = new LayeredLexer((Lexer)customFileTypeLexer);
            ((LayeredLexer)customFileTypeLexer).registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', CustomHighlighterTokenType.STRING, true, "x"), new IElementType[]{CustomHighlighterTokenType.STRING}, IElementType.EMPTY_ARRAY);
            ((LayeredLexer)customFileTypeLexer).registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', CustomHighlighterTokenType.STRING, true, "x"), new IElementType[]{CustomHighlighterTokenType.SINGLE_QUOTED_STRING}, IElementType.EMPTY_ARRAY);
        }
        return customFileTypeLexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        return CustomFileHighlighter.pack((TextAttributesKey)ourKeys.get(tokenType));
    }

    public static Map<IElementType, TextAttributesKey> getKeys() {
        return ourKeys;
    }

    static {
        ourKeys.put(CustomHighlighterTokenType.KEYWORD_1, CustomHighlighterColors.CUSTOM_KEYWORD1_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.KEYWORD_2, CustomHighlighterColors.CUSTOM_KEYWORD2_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.KEYWORD_3, CustomHighlighterColors.CUSTOM_KEYWORD3_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.KEYWORD_4, CustomHighlighterColors.CUSTOM_KEYWORD4_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.NUMBER, CustomHighlighterColors.CUSTOM_NUMBER_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.STRING, CustomHighlighterColors.CUSTOM_STRING_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.SINGLE_QUOTED_STRING, CustomHighlighterColors.CUSTOM_STRING_ATTRIBUTES);
        ourKeys.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, CustomHighlighterColors.CUSTOM_VALID_STRING_ESCAPE);
        ourKeys.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, CustomHighlighterColors.CUSTOM_INVALID_STRING_ESCAPE);
        ourKeys.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, CustomHighlighterColors.CUSTOM_INVALID_STRING_ESCAPE);
        ourKeys.put(CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterColors.CUSTOM_LINE_COMMENT_ATTRIBUTES);
        ourKeys.put(CustomHighlighterTokenType.MULTI_LINE_COMMENT, CustomHighlighterColors.CUSTOM_MULTI_LINE_COMMENT_ATTRIBUTES);
    }
}

