/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String CALLEE_TYPE = "Callees of {0}";
    public static final String CALLER_TYPE = "Callers of {0}";
    private static final String CALL_HIERARCHY_BROWSER_DATA_KEY = "com.intellij.ide.hierarchy.CallHierarchyBrowserBase";

    public CallHierarchyBrowserBase(@NotNull Project project, @NotNull PsiElement method2) {
        super(project, method2);
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        return CALL_HIERARCHY_BROWSER_DATA_KEY;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Supertypes, CallHierarchyBrowserBase.getCallerType()));
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), AllIcons.Hierarchy.Subtypes, CallHierarchyBrowserBase.getCalleeType()));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction(this));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(this));
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        return "CallHierarchyViewToolbar";
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        return IdeBundle.message((String)"hierarchy.call.prev.occurence.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        return IdeBundle.message((String)"hierarchy.call.next.occurence.name", (Object[])new Object[0]);
    }

    @Override
    protected Map<String, Supplier<String>> getPresentableNameMap() {
        HashMap<String, Supplier<String>> map2 = new HashMap<String, Supplier<String>>();
        map2.put(CALLER_TYPE, CallHierarchyBrowserBase::getCallerType);
        map2.put(CALLEE_TYPE, CallHierarchyBrowserBase::getCalleeType);
        return map2;
    }

    public static String getCalleeType() {
        return IdeBundle.message((String)"title.hierarchy.callees.of", (Object[])new Object[0]);
    }

    public static String getCallerType() {
        return IdeBundle.message((String)"title.hierarchy.callers.of", (Object[])new Object[0]);
    }

    protected static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.messagePointer((String)"action.base.on.this.method", (Object[])new Object[0]), CallHierarchyBrowserBase.CALL_HIERARCHY_BROWSER_DATA_KEY, (LanguageExtension<HierarchyProvider>)LanguageCallHierarchy.INSTANCE);
        }
    }

    private class ChangeViewTypeActionBase
    extends ToggleAction {
        private final String myTypeName;

        private ChangeViewTypeActionBase(String shortDescription, String longDescription, Icon icon2, String typeName) {
            super(shortDescription, longDescription, icon2);
            this.myTypeName = typeName;
        }

        public final boolean isSelected(@NotNull AnActionEvent event) {
            return this.myTypeName.equals(CallHierarchyBrowserBase.this.getCurrentViewType());
        }

        public final void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (flag) {
                ApplicationManager.getApplication().invokeLater(() -> CallHierarchyBrowserBase.this.changeView(this.myTypeName));
            }
        }

        public final void update(@NotNull AnActionEvent event) {
            super.update(event);
            CallHierarchyBrowserBase.this.setEnabled(CallHierarchyBrowserBase.this.isValidBase());
        }
    }
}

