/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.ui.AppUIUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConsentConfigurable
extends ConfigurableBase<ConsentSettingsUi, List<Consent>> {
    private final List<Consent> myConsents = new ArrayList<Consent>(AppUIUtil.loadConsentsForEditing());

    public ConsentConfigurable() {
        super("consents", IdeBundle.message((String)"consent.configurable", (Object[])new Object[0]), "preferences.usage.statistics");
    }

    @NotNull
    protected List<Consent> getSettings() {
        return this.myConsents;
    }

    protected ConsentSettingsUi createUi() {
        ConsentSettingsUi ui = new ConsentSettingsUi(true){

            @Override
            public void apply(@NotNull List<Consent> consents) {
                super.apply(consents);
                AppUIUtil.saveConsents(consents);
            }
        };
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ui.reset(this.myConsents);
        }
        return ui;
    }
}

