/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.gdpr.AgreementUi;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AppUIUtil;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/gdpr/Agreements;", "", "()V", "bundle", "Ljava/util/ResourceBundle;", "kotlin.jvm.PlatformType", "getBundle", "()Ljava/util/ResourceBundle;", "isEap", "", "()Z", "prepareConsentsHtmlText", "", "consent", "Lcom/intellij/ide/gdpr/Consent;", "showDataSharingAgreement", "", "showEndUserAndDataSharingAgreements", "agreement", "Lcom/intellij/ide/gdpr/EndUserAgreement$Document;", "applyDataSharing", "Lcom/intellij/ide/gdpr/AgreementUi;", "applyUserAgreement", "intellij.platform.ide.impl"})
public final class Agreements {
    public static final Agreements INSTANCE;

    private final ResourceBundle getBundle() {
        return ResourceBundle.getBundle("messages.AgreementsBundle");
    }

    private final boolean isEap() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public final void showEndUserAndDataSharingAgreements(@NotNull EndUserAgreement.Document agreement) {
        AgreementUi agreementUi = AgreementUi.Companion.create(agreement.getText());
        DialogWrapper dialog2 = this.applyUserAgreement(agreementUi, agreement).pack();
        SplashManager.executeWithHiddenSplash(dialog2.getWindow(), new Runnable(dialog2){
            final /* synthetic */ DialogWrapper $dialog;

            public final void run() {
                this.$dialog.show();
            }
            {
                this.$dialog = dialogWrapper2;
            }
        });
    }

    public final void showDataSharingAgreement() {
        AgreementUi agreementUi = AgreementUi.Companion.create$default(AgreementUi.Companion, null, 1, null);
        DialogWrapper dialog2 = this.applyDataSharing(agreementUi).pack();
        SplashManager.executeWithHiddenSplash(dialog2.getWindow(), new Runnable(dialog2){
            final /* synthetic */ DialogWrapper $dialog;

            public final void run() {
                this.$dialog.show();
            }
            {
                this.$dialog = dialogWrapper2;
            }
        });
    }

    private final AgreementUi applyUserAgreement(AgreementUi $this$applyUserAgreement, EndUserAgreement.Document agreement) {
        boolean isPrivacyPolicy = agreement.isPrivacyPolicy();
        AgreementUi commonUserAgreement2 = $this$applyUserAgreement.setTitle(isPrivacyPolicy ? ApplicationInfoImpl.getShadowInstance().getShortCompanyName() + " " + this.getBundle().getString("userAgreement.dialog.privacyPolicy.title") : ApplicationNamesInfo.getInstance().getFullProductName() + " " + this.getBundle().getString("userAgreement.dialog.userAgreement.title")).setDeclineButton(this.getBundle().getString("userAgreement.dialog.exit"), (Function1<? super DialogWrapper, Unit>)((Function1)applyUserAgreement.commonUserAgreement.1.INSTANCE)).addCheckBox(this.getBundle().getString("userAgreement.dialog.checkBox"), (Function1<? super JCheckBox, Unit>)((Function1)new Function1<JCheckBox, Unit>($this$applyUserAgreement){
            final /* synthetic */ AgreementUi $this_applyUserAgreement;

            public final void invoke(@NotNull JCheckBox checkBox2) {
                this.$this_applyUserAgreement.enableAcceptButton(checkBox2.isSelected());
                if (checkBox2.isSelected()) {
                    this.$this_applyUserAgreement.focusToAcceptButton();
                }
            }
            {
                this.$this_applyUserAgreement = agreementUi;
                super(1);
            }
        }));
        if (!this.isEap()) {
            commonUserAgreement2.setAcceptButton(this.getBundle().getString("userAgreement.dialog.continue"), false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>($this$applyUserAgreement, agreement){
                final /* synthetic */ AgreementUi $this_applyUserAgreement;
                final /* synthetic */ EndUserAgreement.Document $agreement;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    EndUserAgreement.setAccepted(this.$agreement);
                    if (AppUIUtil.needToShowConsentsAgreement()) {
                        Agreements.access$applyDataSharing(Agreements.INSTANCE, this.$this_applyUserAgreement);
                    } else {
                        dialogWrapper2.close(0);
                    }
                }
                {
                    this.$this_applyUserAgreement = agreementUi;
                    this.$agreement = document;
                    super(1);
                }
            }));
        } else {
            commonUserAgreement2.setAcceptButton(this.getBundle().getString("userAgreement.dialog.continue"), false, (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(agreement){
                final /* synthetic */ EndUserAgreement.Document $agreement;

                public final void invoke(@NotNull DialogWrapper dialogWrapper2) {
                    EndUserAgreement.setAccepted(this.$agreement);
                    dialogWrapper2.close(0);
                }
                {
                    this.$agreement = document;
                    super(1);
                }
            })).addEapPanel(isPrivacyPolicy);
        }
        return $this$applyUserAgreement;
    }

    private final AgreementUi applyDataSharing(AgreementUi $this$applyDataSharing) {
        Consent dataSharingConsent = (Consent)((List)ConsentOptions.getInstance().getConsents().first).get(0);
        AgreementUi.setAcceptButton$default($this$applyDataSharing.setText(this.prepareConsentsHtmlText(dataSharingConsent)).setTitle(this.getBundle().getString("dataSharing.dialog.title")).clearBottomPanel().focusToText(), this.getBundle().getString("dataSharing.dialog.accept"), false, (Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Consent consentToSave = this.$dataSharingConsent.derive(true);
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)consentToSave));
                it.close(0);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }, 2, null).setDeclineButton(this.getBundle().getString("dataSharing.dialog.decline"), (Function1<? super DialogWrapper, Unit>)((Function1)new Function1<DialogWrapper, Unit>(dataSharingConsent){
            final /* synthetic */ Consent $dataSharingConsent;

            public final void invoke(@NotNull DialogWrapper it) {
                Consent consentToSave = this.$dataSharingConsent.derive(false);
                AppUIUtil.saveConsents(CollectionsKt.listOf((Object)consentToSave));
                it.close(1);
            }
            {
                this.$dataSharingConsent = consent;
                super(1);
            }
        }));
        return $this$applyDataSharing;
    }

    private final String prepareConsentsHtmlText(Consent consent) {
        String allProductHint = !ConsentOptions.getInstance().isEAP() ? StringsKt.replace$default((String)("<p><hint>" + this.getBundle().getString("dataSharing.applyToAll.hint") + "</hint></p>"), (String)"{0}", (String)ApplicationInfoImpl.getShadowInstance().getShortCompanyName(), (boolean)false, (int)4, null) : "";
        String preferencesHint = "<p><hint>" + StringsKt.replace$default((String)this.getBundle().getString("dataSharing.revoke.hint"), (String)"{0}", (String)ShowSettingsUtil.getSettingsMenuName(), (boolean)false, (int)4, null) + "</hint></p>";
        return "<html><body> <h1>" + this.getBundle().getString("dataSharing.consents.title") + "</h1>" + "<p>" + StringsKt.replace$default((String)consent.getText(), (String)"\n", (String)"</p><p>", (boolean)false, (int)4, null) + "</p>" + allProductHint + preferencesHint + "</body></html>";
    }

    private Agreements() {
    }

    static {
        Agreements agreements;
        INSTANCE = agreements = new Agreements();
    }

    public static final /* synthetic */ AgreementUi access$applyDataSharing(Agreements $this, AgreementUi $this$access_u24applyDataSharing) {
        return $this.applyDataSharing($this$access_u24applyDataSharing);
    }
}

