/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.CommonBundle;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsList;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.IdeLanguageCustomization;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllFileTemplatesConfigurable
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel,
Configurable.WithEpDependencies {
    private static final Logger LOG = Logger.getInstance(AllFileTemplatesConfigurable.class);
    private final Project myProject;
    private final FileTemplateManager myManager;
    private JPanel myMainPanel;
    private FileTemplateTab myCurrentTab;
    private FileTemplateTab myTemplatesList;
    private FileTemplateTab myIncludesList;
    private FileTemplateTab myCodeTemplatesList;
    @Nullable
    private FileTemplateTab myOtherTemplatesList;
    private JComponent myToolBar;
    private TabbedPaneWrapper myTabbedPane;
    private FileTemplateConfigurable myEditor;
    private boolean myModified;
    private JComponent myEditorComponent;
    private JPanel myLeftPanel;
    private SchemesPanel mySchemesPanel;
    private FileTemplateTab[] myTabs;
    private Disposable myUIDisposable;
    private final Set<String> myInternalTemplateNames;
    private FileTemplatesScheme myScheme;
    private final Map<FileTemplatesScheme, Map<String, FileTemplate[]>> myChangesCache = new HashMap<FileTemplatesScheme, Map<String, FileTemplate[]>>();
    private static final String CURRENT_TAB = "FileTemplates.CurrentTab";
    private static final String SELECTED_TEMPLATE = "FileTemplates.SelectedTemplate";

    public AllFileTemplatesConfigurable(Project project) {
        this.myProject = project;
        this.myManager = FileTemplateManager.getInstance(project);
        this.myScheme = this.myManager.getCurrentScheme();
        this.myInternalTemplateNames = ContainerUtil.map2Set((Object[])this.myManager.getInternalTemplates(), FileTemplate::getName);
    }

    private void onRemove() {
        this.myCurrentTab.removeSelected();
        this.myModified = true;
    }

    private void onAdd() {
        String ext = (String)JBIterable.from((Iterable)IdeLanguageCustomization.getInstance().getPrimaryIdeLanguages()).filterMap(Language::getAssociatedFileType).filterMap(FileType::getDefaultExtension).first();
        this.createTemplate(IdeBundle.message((String)"template.unnamed", (Object[])new Object[0]), StringUtil.notNullize((String)ext, (String)"txt"), "");
    }

    @NotNull
    FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension, @NotNull String content2) {
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        FileTemplate newTemplate = FileTemplateUtil.createTemplate(prefName, extension, content2, templates);
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
        this.myEditor.focusToNameField();
        return newTemplate;
    }

    private void onClone() {
        try {
            this.myEditor.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        FileTemplate selected2 = this.myCurrentTab.getSelectedTemplate();
        if (selected2 == null) {
            return;
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        HashSet<String> names2 = new HashSet<String>();
        for (FileTemplate template : templates) {
            names2.add(template.getName());
        }
        String nameTemplate = IdeBundle.message((String)"template.copy.N.of.T", (Object[])new Object[0]);
        String name = MessageFormat.format(nameTemplate, "", selected2.getName());
        int i2 = 0;
        while (names2.contains(name)) {
            name = MessageFormat.format(nameTemplate, ++i2 + " ", selected2.getName());
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, selected2.getExtension());
        newTemplate.setText(selected2.getText());
        newTemplate.setReformatCode(selected2.isReformatCode());
        newTemplate.setLiveTemplateEnabled(selected2.isLiveTemplateEnabled());
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        int index = this.myTabbedPane.getSelectedIndex();
        switch (index) {
            case 0: {
                return "fileTemplates.templates";
            }
            case 1: {
                return "fileTemplates.includes";
            }
            case 2: {
                return "fileTemplates.code";
            }
            case 3: {
                return "fileTemplates.j2ee";
            }
        }
        throw new IllegalStateException("wrong index: " + index);
    }

    public JComponent createComponent() {
        this.myUIDisposable = Disposer.newDisposable();
        this.myTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getTemplatesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myIncludesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getIncludesTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCodeTemplatesList = new FileTemplateTabAsList(AllFileTemplatesConfigurable.getCodeTitle()){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCurrentTab = this.myTemplatesList;
        ArrayList<FileTemplateTab> allTabs = new ArrayList<FileTemplateTab>(Arrays.asList(this.myTemplatesList, this.myIncludesList, this.myCodeTemplatesList));
        final List factories2 = FileTemplateGroupDescriptorFactory.EXTENSION_POINT_NAME.getExtensionList();
        if (!factories2.isEmpty()) {
            this.myOtherTemplatesList = new FileTemplateTabAsTree(AllFileTemplatesConfigurable.getOtherTitle()){

                @Override
                public void onTemplateSelected() {
                    AllFileTemplatesConfigurable.this.onListSelectionChanged();
                }

                @Override
                protected FileTemplateTabAsTree.FileTemplateNode initModel() {
                    TreeSet<FileTemplateGroupDescriptor> categories = new TreeSet<FileTemplateGroupDescriptor>(Comparator.comparing(FileTemplateGroupDescriptor::getTitle));
                    for (FileTemplateGroupDescriptorFactory templateGroupFactory : factories2) {
                        ContainerUtil.addIfNotNull(categories, (Object)templateGroupFactory.getFileTemplatesDescriptor());
                    }
                    return new FileTemplateTabAsTree.FileTemplateNode("ROOT", null, ContainerUtil.map2List(categories, FileTemplateTabAsTree.FileTemplateNode::new));
                }
            };
            allTabs.add(this.myOtherTemplatesList);
        }
        this.myEditor = new FileTemplateConfigurable(this.myProject);
        this.myEditor.addChangeListener(__ -> this.onEditorChanged());
        this.myEditorComponent = this.myEditor.createComponent();
        this.myEditorComponent.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)10, (int)10));
        this.myTabs = allTabs.toArray(new FileTemplateTab[0]);
        this.myTabbedPane = new TabbedPaneWrapper(this.myUIDisposable);
        this.myTabbedPane.setTabLayoutPolicy(1);
        this.myLeftPanel = new JPanel(new CardLayout());
        for (FileTemplateTab tab : this.myTabs) {
            this.myLeftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tab.getComponent()), tab.getTitle());
            JPanel fakePanel = new JPanel();
            fakePanel.setPreferredSize(new Dimension(0, 0));
            this.myTabbedPane.addTab(tab.getTitle(), fakePanel);
        }
        this.myTabbedPane.addChangeListener(__ -> this.onTabChanged());
        DefaultActionGroup group = new DefaultActionGroup();
        DumbAwareAction removeAction = new DumbAwareAction(IdeBundle.message((String)"action.remove.template", (Object[])new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onRemove();
            }

            public void update(@NotNull AnActionEvent e) {
                if (AllFileTemplatesConfigurable.this.myCurrentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem != null && !AllFileTemplatesConfigurable.isInternalTemplate(selectedItem.getName(), AllFileTemplatesConfigurable.this.myCurrentTab.getTitle()));
            }
        };
        DumbAwareAction addAction = new DumbAwareAction(IdeBundle.message((String)"action.create.template", (Object[])new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onAdd();
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList);
            }
        };
        DumbAwareAction cloneAction = new DumbAwareAction(IdeBundle.message((String)"action.copy.template", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onClone();
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate() != null);
            }
        };
        DumbAwareAction resetAction = new DumbAwareAction(IdeBundle.message((String)"action.reset.to.default", (Object[])new Object[0]), null, AllIcons.Actions.Rollback){

            public void actionPerformed(@NotNull AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onReset();
            }

            public void update(@NotNull AnActionEvent e) {
                if (AllFileTemplatesConfigurable.this.myCurrentTab == null) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem instanceof BundledFileTemplate && !selectedItem.isDefault());
            }
        };
        group.add((AnAction)addAction);
        group.add((AnAction)removeAction);
        group.add((AnAction)cloneAction);
        group.add((AnAction)resetAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, this.myCurrentTab.getComponent());
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.myCurrentTab.getComponent());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("FileTemplatesConfigurable", (ActionGroup)group, true).getComponent();
        this.myToolBar.setBorder((Border)new CustomLineBorder(1, 1, 0, 1));
        this.mySchemesPanel = new SchemesPanel();
        this.mySchemesPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)0, (int)10));
        this.mySchemesPanel.resetSchemes(Arrays.asList(FileTemplatesScheme.DEFAULT, this.myManager.getProjectScheme()));
        JPanel leftPanelWrapper = new JPanel(new BorderLayout());
        leftPanelWrapper.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
        leftPanelWrapper.add("North", this.myToolBar);
        leftPanelWrapper.add("Center", this.myLeftPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myTabbedPane.getComponent(), "North");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setDividerWidth(JBUIScale.scale((int)10));
        splitter.setFirstComponent((JComponent)leftPanelWrapper);
        splitter.setSecondComponent(this.myEditorComponent);
        centerPanel.add((Component)splitter, "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.mySchemesPanel, "North");
        this.myMainPanel.add((Component)centerPanel, "Center");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String tabName = propertiesComponent.getValue(CURRENT_TAB);
        this.selectTab(tabName);
        return this.myMainPanel;
    }

    private void onReset() {
        FileTemplate selected2 = this.myCurrentTab.getSelectedTemplate();
        if (selected2 instanceof BundledFileTemplate) {
            if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.reset.to.original.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.reset.template", (Object[])new Object[0]), (String)LangBundle.message((String)"button.reset", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            ((BundledFileTemplate)selected2).revertToDefaults();
            this.myEditor.reset();
            this.myModified = true;
        }
    }

    private void onEditorChanged() {
        this.fireListChanged();
    }

    private void onTabChanged() {
        this.applyEditor(this.myCurrentTab.getSelectedTemplate());
        FileTemplateTab tab = this.myCurrentTab;
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.myTabs.length) {
            this.myCurrentTab = this.myTabs[selectedIndex];
        }
        ((CardLayout)this.myLeftPanel.getLayout()).show(this.myLeftPanel, this.myCurrentTab.getTitle());
        this.onListSelectionChanged();
        if (tab != this.myCurrentTab) {
            EventQueue.invokeLater(this.myCurrentTab.getComponent()::requestFocus);
        }
    }

    private void onListSelectionChanged() {
        FileTemplate prevTemplate;
        FileTemplate selectedValue = this.myCurrentTab.getSelectedTemplate();
        FileTemplate fileTemplate = prevTemplate = this.myEditor == null ? null : this.myEditor.getTemplate();
        if (prevTemplate != selectedValue) {
            LOG.assertTrue(this.myEditor != null, (Object)("selected:" + selectedValue + "; prev:" + prevTemplate));
            if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate) && !this.applyEditor(prevTemplate)) {
                return;
            }
            if (selectedValue == null) {
                this.myEditor.setTemplate(null, FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription());
                this.myEditorComponent.repaint();
            } else {
                this.selectTemplate(selectedValue);
            }
        }
    }

    private boolean applyEditor(FileTemplate prevTemplate) {
        if (this.myEditor.isModified()) {
            try {
                this.myModified = true;
                this.myEditor.apply();
                this.fireListChanged();
            }
            catch (ConfigurationException e) {
                if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate)) {
                    this.myCurrentTab.selectTemplate(prevTemplate);
                }
                Messages.showErrorDialog((Component)this.myMainPanel, (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.save.current.template", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void selectTemplate(FileTemplate template) {
        URL defDesc = null;
        if (this.myCurrentTab == this.myTemplatesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription();
        } else if (this.myCurrentTab == this.myIncludesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultIncludeDescription();
        }
        if (this.myEditor.getTemplate() != template) {
            this.myEditor.setTemplate(template, defDesc);
            boolean isInternal = template != null && AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), this.myCurrentTab.getTitle());
            this.myEditor.setShowInternalMessage(isInternal ? " " : null);
            this.myEditor.setShowAdjustCheckBox(this.myTemplatesList == this.myCurrentTab);
        }
    }

    public boolean isProjectLevel() {
        return this.myScheme != null && this.myScheme != FileTemplatesScheme.DEFAULT && !this.myScheme.getProject().isDefault();
    }

    static boolean isInternalTemplate(String templateName, String templateTabTitle) {
        if (templateName == null) {
            return false;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getTemplatesTitle())) {
            return AllFileTemplatesConfigurable.isInternalTemplateName(templateName);
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getCodeTitle())) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getOtherTitle())) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)AllFileTemplatesConfigurable.getIncludesTitle())) {
            return Comparing.strEqual((String)templateName, (String)"File Header");
        }
        return false;
    }

    private static boolean isInternalTemplateName(String templateName) {
        for (InternalTemplateBean bean : InternalTemplateBean.EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual((String)templateName, (String)bean.name)) continue;
            return true;
        }
        return false;
    }

    private void initLists() {
        FileTemplatesScheme scheme = this.myManager.getCurrentScheme();
        this.myManager.setCurrentScheme(this.myScheme);
        this.myTemplatesList.init(this.getTemplates("Default"));
        this.myIncludesList.init(this.getTemplates("Includes"));
        this.myCodeTemplatesList.init(this.getTemplates("Code"));
        this.myTabbedPane.setEnabledAt(2, !this.myCodeTemplatesList.myTemplates.isEmpty());
        if (this.myOtherTemplatesList != null) {
            this.myOtherTemplatesList.init(this.getTemplates("J2EE"));
        }
        this.myManager.setCurrentScheme(scheme);
    }

    private FileTemplate[] getTemplates(String category) {
        Map<String, FileTemplate[]> templates = this.myChangesCache.get(this.myScheme);
        if (templates == null) {
            return this.myManager.getTemplates(category);
        }
        return templates.get(category);
    }

    public boolean isModified() {
        return this.myScheme != this.myManager.getCurrentScheme() || !this.myChangesCache.isEmpty() || this.isSchemeModified();
    }

    private boolean isSchemeModified() {
        return this.myModified || this.myEditor != null && this.myEditor.isModified();
    }

    private void checkCanApply(FileTemplateTab list2) throws ConfigurationException {
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> allNames = new ArrayList<String>();
        FileTemplate itemWithError = null;
        String errorString = null;
        for (FileTemplate template : templates) {
            String currName = template.getName();
            if (currName.isEmpty()) {
                itemWithError = template;
                errorString = IdeBundle.message((String)"error.please.specify.template.name", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = template;
                errorString = LangBundle.message((String)"dialog.message.template.with.name.already.exists", (Object[])new Object[]{currName});
                break;
            }
            allNames.add(currName);
        }
        if (itemWithError != null) {
            this.myTabbedPane.setSelectedIndex(Arrays.asList(this.myTabs).indexOf(list2));
            this.selectTemplate(itemWithError);
            list2.selectTemplate(itemWithError);
            ApplicationManager.getApplication().invokeLater(this.myEditor::focusToNameField);
            throw new ConfigurationException(errorString);
        }
    }

    private void fireListChanged() {
        if (this.myCurrentTab != null) {
            this.myCurrentTab.fireDataChanged();
        }
        if (this.myMainPanel != null) {
            this.myMainPanel.revalidate();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            this.myEditor.apply();
        }
        for (FileTemplateTab list2 : this.myTabs) {
            this.checkCanApply(list2);
        }
        this.updateCache();
        for (Map.Entry entry : this.myChangesCache.entrySet()) {
            this.myManager.setCurrentScheme((FileTemplatesScheme)entry.getKey());
            Map templates = (Map)entry.getValue();
            this.myManager.setTemplates("Default", Arrays.asList((Object[])templates.get("Default")));
            this.myManager.setTemplates("Internal", Arrays.asList((Object[])templates.get("Internal")));
            this.myManager.setTemplates("Includes", Arrays.asList((Object[])templates.get("Includes")));
            this.myManager.setTemplates("Code", Arrays.asList((Object[])templates.get("Code")));
            this.myManager.setTemplates("J2EE", Arrays.asList((Object[])templates.get("J2EE")));
        }
        this.myChangesCache.clear();
        this.myManager.setCurrentScheme(this.myScheme);
        if (this.myEditor != null) {
            this.myModified = false;
            this.fireListChanged();
        }
    }

    private boolean selectTab(String tabName) {
        int idx = 0;
        for (FileTemplateTab tab : this.myTabs) {
            if (Comparing.strEqual((String)tab.getTitle(), (String)tabName)) {
                this.myCurrentTab = tab;
                this.myTabbedPane.setSelectedIndex(idx);
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void reset() {
        this.myEditor.reset();
        this.changeScheme(this.myManager.getCurrentScheme());
        this.mySchemesPanel.selectScheme(this.myScheme);
        this.myChangesCache.clear();
        this.myModified = false;
    }

    public void disposeUIResources() {
        if (this.myCurrentTab != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            propertiesComponent.setValue(CURRENT_TAB, this.myCurrentTab.getTitle(), AllFileTemplatesConfigurable.getTemplatesTitle());
            FileTemplate template = this.myCurrentTab.getSelectedTemplate();
            if (template != null) {
                propertiesComponent.setValue(SELECTED_TEMPLATE, template.getName());
            }
        }
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myEditor = null;
            this.myEditorComponent = null;
        }
        this.myMainPanel = null;
        if (this.myUIDisposable != null) {
            Disposer.dispose((Disposable)this.myUIDisposable);
            this.myUIDisposable = null;
        }
        this.myTabbedPane = null;
        this.myToolBar = null;
        this.myTabs = null;
        this.myCurrentTab = null;
        this.myTemplatesList = null;
        this.myCodeTemplatesList = null;
        this.myIncludesList = null;
        this.myOtherTemplatesList = null;
    }

    @NotNull
    public String getId() {
        return "fileTemplates";
    }

    public static void editCodeTemplate(@NotNull String templateId, Project project) {
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        AllFileTemplatesConfigurable configurable2 = new AllFileTemplatesConfigurable(project);
        util.editConfigurable(project, (Configurable)configurable2, () -> {
            configurable2.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf((Object[])configurable2.myTabs, (Object)configurable2.myCodeTemplatesList));
            for (FileTemplate template : configurable2.myCodeTemplatesList.getTemplates()) {
                if (!Objects.equals(templateId, template.getName())) continue;
                configurable2.myCodeTemplatesList.selectTemplate(template);
                break;
            }
        });
    }

    void changeScheme(@NotNull FileTemplatesScheme scheme) {
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            try {
                this.myEditor.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.myEditorComponent, (String)e.getMessage(), (String)e.getTitle());
                return;
            }
        }
        this.updateCache();
        this.myScheme = scheme;
        this.initLists();
    }

    private void updateCache() {
        if (this.isSchemeModified() && !this.myChangesCache.containsKey(this.myScheme)) {
            HashMap<String, FileTemplate[]> templates = new HashMap<String, FileTemplate[]>();
            Object[] allTemplates = this.myTemplatesList.getTemplates();
            templates.put("Default", ContainerUtil.filter((Object[])allTemplates, template -> !this.myInternalTemplateNames.contains(template.getName())).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Internal", ContainerUtil.filter((Object[])allTemplates, template -> this.myInternalTemplateNames.contains(template.getName())).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Includes", this.myIncludesList.getTemplates());
            templates.put("Code", this.myCodeTemplatesList.getTemplates());
            templates.put("J2EE", this.myOtherTemplatesList == null ? FileTemplate.EMPTY_ARRAY : this.myOtherTemplatesList.getTemplates());
            this.myChangesCache.put(this.myScheme, templates);
        }
    }

    @NotNull
    public FileTemplateManager getManager() {
        return this.myManager;
    }

    FileTemplateConfigurable getEditor() {
        return this.myEditor;
    }

    FileTemplateTab[] getTabs() {
        return this.myTabs;
    }

    private static String getTemplatesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.templates", (Object[])new Object[0]);
    }

    private static String getIncludesTitle() {
        return IdeBundle.message((String)"tab.filetemplates.includes", (Object[])new Object[0]);
    }

    private static String getCodeTitle() {
        return IdeBundle.message((String)"tab.filetemplates.code", (Object[])new Object[0]);
    }

    private static String getOtherTitle() {
        return IdeBundle.message((String)"tab.filetemplates.j2ee", (Object[])new Object[0]);
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return Collections.singleton(InternalTemplateBean.EP_NAME);
    }

    private final class SchemesPanel
    extends SimpleSchemesPanel<FileTemplatesScheme>
    implements SchemesModel<FileTemplatesScheme> {
        private SchemesPanel() {
        }

        @Override
        @NotNull
        protected AbstractSchemeActions<FileTemplatesScheme> createSchemeActions() {
            return new AbstractSchemeActions<FileTemplatesScheme>((AbstractSchemesPanel)this){

                @Override
                protected void resetScheme(@NotNull FileTemplatesScheme scheme) {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void duplicateScheme(@NotNull FileTemplatesScheme scheme, @NotNull String newName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected void onSchemeChanged(@Nullable FileTemplatesScheme scheme) {
                    if (scheme != null) {
                        AllFileTemplatesConfigurable.this.changeScheme(scheme);
                    }
                }

                @Override
                protected void renameScheme(@NotNull FileTemplatesScheme scheme, @NotNull String newName) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @NotNull
                protected Class<FileTemplatesScheme> getSchemeType() {
                    return FileTemplatesScheme.class;
                }
            };
        }

        @Override
        @NotNull
        public SchemesModel<FileTemplatesScheme> getModel() {
            return this;
        }

        @Override
        protected boolean supportsProjectSchemes() {
            return false;
        }

        @Override
        protected boolean highlightNonDefaultSchemes() {
            return false;
        }

        @Override
        public boolean useBoldForNonRemovableSchemes() {
            return true;
        }

        @Override
        public boolean canDuplicateScheme(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public boolean canResetScheme(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public boolean canDeleteScheme(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public boolean isProjectScheme(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public boolean canRenameScheme(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public boolean containsScheme(@NotNull String name, boolean projectScheme) {
            return false;
        }

        @Override
        public boolean differsFromDefault(@NotNull FileTemplatesScheme scheme) {
            return false;
        }

        @Override
        public void removeScheme(@NotNull FileTemplatesScheme scheme) {
            throw new UnsupportedOperationException();
        }
    }

    static final class Provider
    extends ConfigurableProvider {
        private final Project myProject;

        Provider(@NotNull Project project) {
            this.myProject = project;
        }

        @NotNull
        public Configurable createConfigurable() {
            return new AllFileTemplatesConfigurable(this.myProject);
        }
    }
}

