/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class FavoritesToolbarButtonAction
extends AnActionButton
implements Toggleable,
DumbAware {
    private FavoritesViewTreeBuilder myBuilder;
    private FavoritesViewSettings mySettings;

    public FavoritesToolbarButtonAction(Project project, FavoritesViewTreeBuilder builder2, @Nls(capitalization=Nls.Capitalization.Title) String name, Icon icon2) {
        super(name, icon2);
        this.myBuilder = builder2;
        this.mySettings = FavoritesManager.getInstance(project).getViewSettings();
        this.setContextComponent(this.myBuilder.getTree());
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesToolbarButtonAction.this.myBuilder = null;
                FavoritesToolbarButtonAction.this.mySettings = null;
            }
        });
    }

    public abstract boolean isOptionEnabled();

    public abstract void setOption(boolean var1);

    public FavoritesViewSettings getViewSettings() {
        return this.mySettings;
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.setOption(!this.isOptionEnabled());
        this.myBuilder.updateFromRootCB();
    }

    public void updateButton(@NotNull AnActionEvent e) {
        super.updateButton(e);
        Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.isOptionEnabled());
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setIcon(null);
        }
    }
}

