/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileDiffElement
extends DiffElement<VirtualFile> {
    private final VirtualFile myFile;

    public VirtualFileDiffElement(@NotNull VirtualFile file2) {
        this.myFile = file2;
    }

    public String getPath() {
        return this.myFile.getPresentableUrl();
    }

    @NotNull
    public String getName() {
        return this.myFile.getName();
    }

    public String getPresentablePath() {
        return this.getPath();
    }

    public long getSize() {
        return this.myFile.getLength();
    }

    public long getTimeStamp() {
        return this.myFile.getTimeStamp();
    }

    public boolean isContainer() {
        return this.myFile.isDirectory();
    }

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        if (project == null || project.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(project, this.myFile);
    }

    public VirtualFileDiffElement[] getChildren() {
        if (this.myFile.is(VFileProperty.SYMLINK)) {
            return new VirtualFileDiffElement[0];
        }
        VirtualFile[] files2 = this.myFile.getChildren();
        ArrayList<VirtualFileDiffElement> elements2 = new ArrayList<VirtualFileDiffElement>();
        for (VirtualFile file2 : files2) {
            if (FileTypeManager.getInstance().isFileIgnored(file2) || !file2.isValid()) continue;
            elements2.add(new VirtualFileDiffElement(file2));
        }
        return elements2.toArray(new VirtualFileDiffElement[0]);
    }

    public byte @Nullable [] getContent() throws IOException {
        return (byte[])ReadAction.compute(() -> this.myFile.contentsToByteArray());
    }

    @Nullable
    public InputStream getContentStream() throws IOException {
        return DiffUtil.getFileInputStream(this.myFile);
    }

    public VirtualFile getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.isContainer() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return () -> {
            FileChooserDescriptor descriptor2 = this.getChooserDescriptor();
            VirtualFile[] result2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)this.getValue());
            return result2.length == 1 ? VirtualFileDiffElement.createElement(result2[0]) : null;
        };
    }

    @NotNull
    public static VirtualFileDiffElement createElement(VirtualFile file2) {
        VirtualFile jar;
        if (file2.getFileType() instanceof ArchiveFileType && file2.getFileSystem() != JarFileSystem.getInstance() && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null) {
            return new VirtualFileDiffElement(jar);
        }
        return new VirtualFileDiffElement(file2);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return file2.isDirectory() || file2.getFileType() instanceof ArchiveFileType;
            }
        };
    }

    public boolean isOperationsEnabled() {
        return this.myFile.getFileSystem() instanceof LocalFileSystem;
    }

    @NotNull
    public Charset getCharset() {
        return this.myFile.getCharset();
    }

    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    public VirtualFileDiffElement copyTo(DiffElement<VirtualFile> container2, String relativePath) {
        try {
            File src = new File(this.myFile.getPath());
            File trg = new File(((VirtualFile)container2.getValue()).getPath() + relativePath + src.getName());
            FileUtil.copy((File)src, (File)trg);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(trg);
            if (virtualFile != null) {
                return new VirtualFileDiffElement(virtualFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean delete() {
        try {
            this.myFile.delete((Object)this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void refresh(boolean userInitiated) {
        VirtualFileDiffElement.refreshFile(userInitiated, this.myFile);
    }

    public static void refreshFile(boolean userInitiated, VirtualFile virtualFile) {
        if (userInitiated) {
            ArrayList<Document> docsToSave = new ArrayList<Document>();
            FileDocumentManager manager = FileDocumentManager.getInstance();
            for (Document document : manager.getUnsavedDocuments()) {
                VirtualFile file2 = manager.getFile(document);
                if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
                docsToSave.add(document);
            }
            if (!docsToSave.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : docsToSave) {
                        manager.saveDocument(document);
                    }
                });
            }
            ModalityState modalityState = ProgressManager.getInstance().getProgressIndicator().getModalityState();
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            RefreshQueue.getInstance().refresh(false, true, null, modalityState, new VirtualFile[]{virtualFile});
        }
    }
}

