/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.PlatformIcons;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OpenUrlHyperlinkInfo
implements HyperlinkWithPopupMenuInfo {
    private final String url;
    private final WebBrowser browser;
    private final Condition<? super WebBrowser> browserCondition;

    public OpenUrlHyperlinkInfo(@NotNull String url) {
        this(url, (Condition<? super WebBrowser>)Conditions.alwaysTrue(), null);
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @Nullable WebBrowser browser2) {
        this(url, (Condition<? super WebBrowser>)Conditions.alwaysTrue(), browser2);
    }

    public OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<? super WebBrowser> browserCondition) {
        this(url, browserCondition, null);
    }

    private OpenUrlHyperlinkInfo(@NotNull String url, @NotNull Condition<? super WebBrowser> browserCondition, @Nullable WebBrowser browser2) {
        this.url = url;
        this.browserCondition = browserCondition;
        this.browser = browser2;
    }

    @Override
    public ActionGroup getPopupMenuGroup(@NotNull MouseEvent event) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (final WebBrowser browser2 : WebBrowserManager.getInstance().getActiveBrowsers()) {
            if (!this.browserCondition.value((Object)browser2)) continue;
            group.add(new AnAction(IdeBundle.message((String)"open.in.0", (Object[])new Object[]{browser2.getName()}), IdeBundle.message((String)"open.url.in.0", (Object[])new Object[]{browser2.getName()}), browser2.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    BrowserLauncher.getInstance().browse(OpenUrlHyperlinkInfo.this.url, browser2, e.getProject());
                }
            });
        }
        group.add(new AnAction(IdeBundle.messagePointer((String)"action.OpenUrlHyperlinkInfo.Anonymous.text.copy.url", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.OpenUrlHyperlinkInfo.Anonymous.description.copy.url.to.clipboard", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(OpenUrlHyperlinkInfo.this.url));
            }
        });
        return group;
    }

    public void navigate(Project project) {
        BrowserLauncher.getInstance().browse(this.url, this.browser, project);
    }
}

