/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.tree;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

abstract class BaseTreeNodeAction
extends AnAction
implements DumbAware {
    BaseTreeNodeAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object sourceComponent = BaseTreeNodeAction.getSourceComponent(e);
        if (sourceComponent instanceof JTree) {
            this.performOn((JTree)sourceComponent);
        } else if (sourceComponent instanceof TreeTable) {
            this.performOn((JTree)((TreeTable)sourceComponent).getTree());
        }
    }

    protected abstract void performOn(JTree var1);

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(BaseTreeNodeAction.enabledOn(BaseTreeNodeAction.getSourceComponent(e)));
    }

    private static boolean enabledOn(Object sourceComponent) {
        if (sourceComponent instanceof JTree) {
            return true;
        }
        return sourceComponent instanceof TreeTable;
    }

    private static Object getSourceComponent(@NotNull AnActionEvent e) {
        return e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
    }
}

