/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SymbolSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private final PersistentSearchEverywhereContributorFilter<LanguageRef> myFilter;

    public SymbolSearchEverywhereContributor(@NotNull AnActionEvent event) {
        super(event);
        this.myFilter = ClassSearchEverywhereContributor.createLanguageFilter((Project)event.getRequiredData(CommonDataKeys.PROJECT));
    }

    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"search.everywhere.group.name.symbols", (Object[])new Object[0]);
    }

    @NotNull
    public String includeNonProjectItemsText() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.symbols", new Object[0]);
    }

    public int getSortWeight() {
        return 300;
    }

    @NotNull
    protected FilteringGotoByModel<LanguageRef> createModel(@NotNull Project project) {
        GotoSymbolModel2 model = new GotoSymbolModel2(project);
        if (this.myFilter != null) {
            model.setFilterItems(this.myFilter.getSelectedElements());
        }
        return model;
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        return this.doGetActions(this.includeNonProjectItemsText(), this.myFilter, onChanged);
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            return new SymbolSearchEverywhereContributor(initEvent);
        }
    }
}

