/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.bigPopup.ShowFilterAction;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchEverywhereUIBase
extends BigPopupUI {
    public static final String SEARCH_EVERYWHERE_SEARCH_FILED_KEY = "search-everywhere-textfield";

    public SearchEverywhereUIBase(Project project) {
        super(project);
    }

    public abstract void toggleEverywhereFilter();

    public abstract void switchToContributor(@NotNull String var1);

    public abstract String getSelectedContributorID();

    @Nullable
    public abstract Object getSelectionIdentity();

    protected static class FiltersAction
    extends ShowFilterAction {
        final PersistentSearchEverywhereContributorFilter<?> filter;
        final Runnable rebuildRunnable;

        public FiltersAction(@NotNull PersistentSearchEverywhereContributorFilter<?> filter2, @NotNull Runnable rebuildRunnable) {
            this.filter = filter2;
            this.rebuildRunnable = rebuildRunnable;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        protected boolean isActive() {
            return this.filter.getAllElements().size() != this.filter.getSelectedElements().size();
        }

        @Override
        protected ElementsChooser<?> createChooser() {
            return FiltersAction.createChooser(this.filter, this.rebuildRunnable);
        }

        private static <T> ElementsChooser<T> createChooser(final @NotNull PersistentSearchEverywhereContributorFilter<T> filter2, @NotNull Runnable rebuildRunnable) {
            ElementsChooser res2 = new ElementsChooser<T>(filter2.getAllElements(), false){

                @Override
                protected String getItemText(@NotNull T value2) {
                    return filter2.getElementText(value2);
                }

                @Override
                @Nullable
                protected Icon getItemIcon(@NotNull T value2) {
                    return filter2.getElementIcon(value2);
                }
            };
            res2.markElements(filter2.getSelectedElements());
            ElementsChooser.ElementsMarkListener<Object> listener2 = (element2, isMarked) -> {
                filter2.setSelected(element2, isMarked);
                rebuildRunnable.run();
            };
            res2.addElementsMarkListener(listener2);
            return res2;
        }
    }
}

