/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.MultiThreadSearcher;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SEListSelectionTracker;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManagerImpl;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUIBase;
import com.intellij.ide.actions.searcheverywhere.ThrottlingListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchFieldStatisticsCollector;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.ide.util.gotoByName.SearchEverywhereConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchEverywhereUI
extends SearchEverywhereUIBase
implements DataProvider,
QuickSearchComponent {
    private static final Logger LOG = Logger.getInstance(SearchEverywhereUI.class);
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    public static final int THROTTLING_TIMEOUT = 100;
    private static final SimpleTextAttributes SMALL_LABEL_ATTRS = new SimpleTextAttributes(128, JBUI.CurrentTheme.BigPopup.listTitleLabelForeground());
    private final List<? extends SearchEverywhereContributor<?>> myShownContributors;
    private SearchListModel myListModel;
    private SETab mySelectedTab;
    private final List<SETab> myTabs = new ArrayList<SETab>();
    private final Function<String, String> myShortcutSupplier;
    private boolean myEverywhereAutoSet = true;
    private String myNotFoundString;
    private JBPopup myHint;
    private final SESearcher mySearcher;
    private final ThrottlingListenerWrapper myBufferedListener;
    private ProgressIndicator mySearchProgressIndicator;
    private final SEListSelectionTracker mySelectionTracker;
    private final PersistentSearchEverywhereContributorFilter<String> myContributorsFilter;
    private ActionToolbar myToolbar;
    private final JLabel myAdvertisementLabel = new JBLabel();
    private static final long REBUILD_LIST_DELAY = 100L;
    private final Alarm rebuildListAlarm;
    private final ListCellRenderer<Object> myCommandRenderer;
    private final ListCellRenderer<Object> myMoreRenderer;
    private final GroupTitleRenderer myGroupTitleRenderer;
    private final SearchListener mySearchListener;
    private final SearchEverywhereContributor<Object> myStubCommandContributor;

    public SearchEverywhereUI(@Nullable Project project, @NotNull List<? extends SearchEverywhereContributor<?>> contributors) {
        this(project, contributors, s -> null);
    }

    public SearchEverywhereUI(@Nullable Project project, @NotNull List<? extends SearchEverywhereContributor<?>> contributors, @NotNull Function<String, String> shortcutSupplier) {
        super(project);
        this.myAdvertisementLabel.setForeground(JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground());
        this.myAdvertisementLabel.setFont(RelativeFont.SMALL.derive(this.getFont()));
        this.rebuildListAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myCommandRenderer = new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                this.setPaintFocusBorder(false);
                this.setIcon(EmptyIcon.ICON_16);
                this.setFont(list2.getFont());
                SearchEverywhereCommandInfo command = (SearchEverywhereCommandInfo)value2;
                this.append(command.getCommandWithPrefix() + " ", new SimpleTextAttributes(0, list2.getForeground()));
                this.append(command.getDefinition(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                this.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
            }
        };
        this.myMoreRenderer = new ColoredListCellRenderer<Object>(){

            protected int getMinHeight() {
                return -1;
            }

            protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                if (value2 != SearchListModel.MORE_ELEMENT) {
                    throw new AssertionError(value2);
                }
                this.setFont(UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
                this.append(IdeBundle.message((String)"search.everywhere.points.more", (Object[])new Object[0]), SMALL_LABEL_ATTRS);
                this.setIpad((Insets)JBInsets.create((int)1, (int)7));
                this.setMyBorder(null);
            }
        };
        this.myGroupTitleRenderer = new GroupTitleRenderer();
        this.mySearchListener = new SearchListener();
        this.myStubCommandContributor = new SearchEverywhereContributor<Object>(){

            @NotNull
            public String getSearchProviderId() {
                return "CommandsContributor";
            }

            @NotNull
            public String getGroupName() {
                return IdeBundle.message((String)"searcheverywhere.commands.tab.name", (Object[])new Object[0]);
            }

            public int getSortWeight() {
                return 10;
            }

            public boolean showInFindResults() {
                return false;
            }

            public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super Object> consumer) {
            }

            public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
                SearchEverywhereUI.this.mySearchField.setText(((SearchEverywhereCommandInfo)selected2).getCommandWithPrefix() + " ");
                SearchEverywhereUI.this.featureTriggered("commandCompleted", null);
                return false;
            }

            @NotNull
            public ListCellRenderer<? super Object> getElementsRenderer() {
                return SearchEverywhereUI.this.myCommandRenderer;
            }

            @Nullable
            public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
                return null;
            }
        };
        List<SEResultsEqualityProvider> equalityProviders = SEResultsEqualityProvider.getProviders();
        this.myBufferedListener = new ThrottlingListenerWrapper(100, this.mySearchListener, Runnable::run);
        this.mySearcher = new MultiThreadSearcher(this.myBufferedListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
        this.myShownContributors = contributors;
        this.myShortcutSupplier = shortcutSupplier;
        Map namesMap = ContainerUtil.map2Map(contributors, c -> Pair.create((Object)c.getSearchProviderId(), (Object)c.getFullGroupName()));
        this.myContributorsFilter = this.isAllTabNeeded() ? new PersistentSearchEverywhereContributorFilter<String>(ContainerUtil.map(contributors, c -> c.getSearchProviderId()), SearchEverywhereConfiguration.getInstance(project), namesMap::get, c -> null) : null;
        this.init();
        this.initSearchActions();
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiSelection;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiSelection = Arrays.stream(selectedIndices).allMatch(i2 -> this.myListModel.getContributorForIndex(i2).isMultiSelectionSupported()))) {
                int index = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index);
            }
        });
        this.mySelectionTracker = new SEListSelectionTracker(this.myResultsList, this.myListModel);
        this.myResultsList.addListSelectionListener((ListSelectionListener)this.mySelectionTracker);
        Disposer.register((Disposable)this, (Disposable)SearchFieldStatisticsCollector.createAndStart((JTextField)this.mySearchField, this.myProject));
    }

    @NotNull
    protected CompositeCellRenderer createCellRenderer() {
        return new CompositeCellRenderer();
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = new SearchListModel();
        this.addListDataListener(this.myListModel);
        return new JBList((ListModel)this.myListModel);
    }

    @Override
    public void toggleEverywhereFilter() {
        this.myEverywhereAutoSet = false;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(!this.mySelectedTab.everywhereAction.isEverywhere());
        this.myToolbar.updateActionsImmediately();
    }

    private boolean isAllTabNeeded() {
        return this.myShownContributors.size() > 1;
    }

    private void setEverywhereAuto(boolean everywhere) {
        this.myEverywhereAutoSet = true;
        if (this.mySelectedTab.everywhereAction == null) {
            return;
        }
        if (!this.mySelectedTab.everywhereAction.canToggleEverywhere()) {
            return;
        }
        this.mySelectedTab.everywhereAction.setEverywhere(everywhere);
        this.myToolbar.updateActionsImmediately();
    }

    private boolean isEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return true;
        }
        return this.mySelectedTab.everywhereAction.isEverywhere();
    }

    private boolean canToggleEverywhere() {
        if (this.mySelectedTab.everywhereAction == null) {
            return false;
        }
        return this.mySelectedTab.everywhereAction.canToggleEverywhere();
    }

    @Override
    public void switchToContributor(@NotNull String contributorID) {
        SETab selectedTab = this.myTabs.stream().filter(tab -> tab.getID().equals(contributorID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Contributor %s is not supported", contributorID)));
        this.switchToTab(selectedTab);
    }

    private void switchToNextTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab nextTab = currentIndex == this.myTabs.size() - 1 ? this.myTabs.get(0) : this.myTabs.get(currentIndex + 1);
        this.switchToTab(nextTab);
    }

    private void switchToPrevTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab prevTab = currentIndex == 0 ? this.myTabs.get(this.myTabs.size() - 1) : this.myTabs.get(currentIndex - 1);
        this.switchToTab(prevTab);
    }

    private void switchToTab(SETab tab) {
        boolean prevTabIsAll = this.mySelectedTab != null && this.isAllTabSelected();
        this.mySelectedTab = tab;
        boolean nextTabIsAll = this.isAllTabSelected();
        if (this.myEverywhereAutoSet && this.isEverywhere() && this.canToggleEverywhere()) {
            this.setEverywhereAuto(false);
        }
        this.updateSearchFieldAdvertisement();
        if (prevTabIsAll != nextTabIsAll) {
            this.myResultsList.setCellRenderer(this.myResultsList.getCellRenderer());
        }
        if (this.myToolbar != null) {
            this.myToolbar.updateActionsImmediately();
        }
        this.repaint();
        this.scheduleRebuildList();
    }

    private void updateSearchFieldAdvertisement() {
        if (this.mySearchField == null) {
            return;
        }
        Boolean commandsSupported = this.mySelectedTab.getContributor().map(contributor -> !contributor.getSupportedCommands().isEmpty()).orElse(true);
        String advertisementText = commandsSupported != false ? IdeBundle.message((String)"searcheverywhere.textfield.hint", (Object[])new Object[]{SearchTopHitProvider.getTopHitAccelerator()}) : (String)this.mySelectedTab.getContributor().map(c -> c.getAdvertisement()).orElse(null);
        this.mySearchField.remove((Component)this.myAdvertisementLabel);
        if (advertisementText != null) {
            this.myAdvertisementLabel.setText(advertisementText);
            this.mySearchField.add((Component)this.myAdvertisementLabel, (Object)"East");
        }
    }

    @Override
    public String getSelectedContributorID() {
        return this.mySelectedTab.getID();
    }

    @Override
    @Nullable
    public Object getSelectionIdentity() {
        Object value2 = this.myResultsList.getSelectedValue();
        return value2 == null ? null : Integer.valueOf(Objects.hashCode(value2));
    }

    public void dispose() {
        this.stopSearching();
        this.myListModel.clear();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        IntStream indicesStream = Arrays.stream(this.myResultsList.getSelectedIndices()).filter(i2 -> !this.myListModel.isMoreElement(i2));
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
            return this.getSearchPattern();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List elements2 = indicesStream.mapToObj(i2 -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
                Object item = this.myListModel.getElementAt(i2);
                Object psi = contributor.getDataForItem(item, CommonDataKeys.PSI_ELEMENT.getName());
                return (PsiElement)psi;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return PsiUtilCore.toPsiElementArray(elements2);
        }
        return indicesStream.mapToObj(i2 -> {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
            Object item = this.myListModel.getElementAt(i2);
            return contributor.getDataForItem(item, dataId);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void registerHint(@NotNull JBPopup h) {
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    public void unregisterHint() {
        this.myHint = null;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element2) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element2);
        }
    }

    private boolean isAllTabSelected() {
        return "SearchEverywhereContributor.All".equals(this.getSelectedContributorID());
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new ActionGroup(){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                if (e == null || SearchEverywhereUI.this.mySelectedTab == null) {
                    return EMPTY_ARRAY;
                }
                return ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.actions.toArray(EMPTY_ARRAY);
            }
        });
        if (this.myProject != null) {
            actionGroup.addAction((AnAction)new ShowInFindToolWindowAction());
        }
        this.myToolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup, true);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.updateActionsImmediately();
        JComponent toolbarComponent = this.myToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        return (JPanel)toolbarComponent;
    }

    @Override
    @NotNull
    protected String getInitialHint() {
        return IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)});
    }

    @Override
    @NotNull
    protected String getAccessibleName() {
        return IdeBundle.message((String)"searcheverywhere.accessible.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        BigPopupUI.SearchField res2 = new BigPopupUI.SearchField(){

            @Override
            @NotNull
            protected ExtendableTextComponent.Extension getLeftExtension() {
                return new ExtendableTextComponent.Extension(){

                    public Icon getIcon(boolean hovered2) {
                        return AllIcons.Actions.Search;
                    }

                    public boolean isIconBeforeText() {
                        return true;
                    }

                    public int getIconGap() {
                        return JBUIScale.scale((int)10);
                    }
                };
            }
        };
        res2.putClientProperty("search-everywhere-textfield", true);
        res2.setLayout(new BorderLayout());
        return res2;
    }

    @Override
    protected void installScrollingActions() {
        ScrollingUtil.installMoveUpAction((JList)this.myResultsList, (JComponent)this.getSearchField());
        ScrollingUtil.installMoveDownAction((JList)this.myResultsList, (JComponent)this.getSearchField());
    }

    @Override
    @NotNull
    protected JPanel createTopLeftPanel() {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        if (this.isAllTabNeeded()) {
            SETab allTab = new SETab(null);
            contributorsPanel.add(allTab);
            this.myTabs.add(allTab);
        }
        this.myShownContributors.stream().filter(SearchEverywhereContributor::isShownInSeparateTab).forEach(contributor -> {
            SETab tab = new SETab((SearchEverywhereContributor<?>)contributor);
            contributorsPanel.add(tab);
            this.myTabs.add(tab);
        });
        return contributorsPanel;
    }

    private void scheduleRebuildList() {
        if (this.rebuildListAlarm.getActiveRequestCount() == 0) {
            this.rebuildListAlarm.addRequest(() -> this.rebuildList(), 100L);
        }
    }

    private void rebuildList() {
        String typedCommand;
        List<SearchEverywhereCommandInfo> commands;
        List<Object> contributors;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopSearching();
        this.myResultsList.setEmptyText(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0]));
        String rawPattern = this.getSearchPattern();
        this.updateViewType(rawPattern.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
        String namePattern = this.mySelectedTab.getContributor().map(contributor -> contributor.filterControlSymbols(rawPattern)).orElse(rawPattern);
        MinusculeMatcher matcher = NameUtil.buildMatcherWithFallback((String)("*" + rawPattern), (String)("*" + namePattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher((JComponent)this.myResultsList, (Matcher)matcher);
        HashMap<Object, Integer> contributorsMap = new HashMap<Object, Integer>();
        Optional<SearchEverywhereContributor<?>> selectedContributor = this.mySelectedTab.getContributor();
        if (selectedContributor.isPresent()) {
            contributorsMap.put(selectedContributor.get(), 30);
        } else {
            contributorsMap.putAll(this.getAllTabContributors().stream().collect(Collectors.toMap(c -> c, c -> 15)));
        }
        if (this.myProject != null) {
            contributors = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(contributorsMap.keySet());
            if (contributors.isEmpty() && DumbService.isDumb((Project)this.myProject)) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.mode.not.supported", (Object[])new Object[]{this.mySelectedTab.getText(), ApplicationNamesInfo.getInstance().getFullProductName()}));
                this.myListModel.clear();
                return;
            }
            if (contributors.size() != contributorsMap.size()) {
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.incomplete.results", (Object[])new Object[]{this.mySelectedTab.getText(), ApplicationNamesInfo.getInstance().getFullProductName()}));
            }
        } else {
            contributors = new ArrayList(contributorsMap.keySet());
        }
        this.myListModel.expireResults();
        contributors.forEach(contributor -> this.myListModel.setHasMore((SearchEverywhereContributor<?>)contributor, false));
        String commandPrefix = SearchTopHitProvider.getTopHitAccelerator();
        if (rawPattern.startsWith(commandPrefix) && !(commands = SearchEverywhereUI.getCommandsForCompletion(contributors, typedCommand = rawPattern.split(" ")[0].substring(commandPrefix.length()))).isEmpty()) {
            if (rawPattern.contains(" ")) {
                contributorsMap.keySet().retainAll(commands.stream().map(SearchEverywhereCommandInfo::getContributor).collect(Collectors.toSet()));
            } else {
                this.myListModel.clear();
                List lst = ContainerUtil.map(commands, command -> new SearchEverywhereFoundElementInfo(command, 0, this.myStubCommandContributor));
                this.myListModel.addElements(lst);
                ScrollingUtil.ensureSelectionExists((JList)this.myResultsList);
            }
        }
        this.mySearchProgressIndicator = this.mySearcher.search(contributorsMap, rawPattern);
    }

    private void initSearchActions() {
        MouseAdapter listMouseListener = new MouseAdapter(){
            private int currentDescriptionIndex = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchEverywhereUI.this.onMouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                this.indexChanged(index);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
                this.indexChanged(index);
            }

            private void indexChanged(int index) {
                if (index != this.currentDescriptionIndex) {
                    this.currentDescriptionIndex = index;
                    SearchEverywhereUI.this.showDescriptionForIndex(index);
                }
            }
        };
        this.myResultsList.addMouseMotionListener((MouseMotionListener)listMouseListener);
        this.myResultsList.addMouseListener((MouseListener)listMouseListener);
        ScrollingUtil.redirectExpandSelection((JList)this.myResultsList, (JComponent)this.mySearchField);
        Consumer nextTabAction = e -> {
            this.switchToNextTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        Consumer prevTabAction = e -> {
            this.switchToPrevTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        this.registerAction("SearchEverywhere.CompleteCommand", () -> new CompleteCommandAction());
        this.registerAction("SearchEverywhere.NextTab", (Consumer<? super AnActionEvent>)nextTabAction);
        this.registerAction("SearchEverywhere.PrevTab", (Consumer<? super AnActionEvent>)prevTabAction);
        this.registerAction("NextTab", (Consumer<? super AnActionEvent>)nextTabAction);
        this.registerAction("PreviousTab", (Consumer<? super AnActionEvent>)prevTabAction);
        this.registerAction("Switcher", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            if (e.getInputEvent().isShiftDown()) {
                this.switchToPrevTab();
            } else {
                this.switchToNextTab();
            }
            this.triggerTabSwitched((AnActionEvent)e);
        }));
        this.registerAction("SearchEverywhere.NavigateToNextGroup", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            this.fetchGroups(true);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
            this.featureTriggered("navigateThroughGroups", data2);
        }));
        this.registerAction("SearchEverywhere.NavigateToPrevGroup", (Consumer<? super AnActionEvent>)((Consumer)e -> {
            this.fetchGroups(false);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
            this.featureTriggered("navigateThroughGroups", data2);
        }));
        this.registerSelectItemAction();
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> this.closePopup()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.myNotFoundString != null) {
                    boolean newPatternContainsPrevious;
                    boolean bl = newPatternContainsPrevious = SearchEverywhereUI.this.myNotFoundString.length() > 1 && newSearchString.contains(SearchEverywhereUI.this.myNotFoundString);
                    if (SearchEverywhereUI.this.myEverywhereAutoSet && SearchEverywhereUI.this.isEverywhere() && SearchEverywhereUI.this.canToggleEverywhere() && !newPatternContainsPrevious) {
                        SearchEverywhereUI.this.myNotFoundString = null;
                        SearchEverywhereUI.this.setEverywhereAuto(false);
                        return;
                    }
                }
                SearchEverywhereUI.this.scheduleRebuildList();
            }
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
            this.showDescriptionForIndex(this.myResultsList.getSelectedIndex());
        });
        MessageBusConnection busConnection = this.myProject != null ? this.myProject.getMessageBus().connect((Disposable)this) : ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    SearchEverywhereUI.this.updateSearchFieldAdvertisement();
                    SearchEverywhereUI.this.scheduleRebuildList();
                });
            }
        });
        busConnection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 == ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.everywhereAction && event.getInputEvent() != null) {
                    SearchEverywhereUI.this.myEverywhereAutoSet = false;
                }
            }
        });
        busConnection.subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (!SearchEverywhereUI.this.isHintComponent(oppositeComponent) && !UIUtil.haveCommonOwner((Component)((Object)SearchEverywhereUI.this), (Component)oppositeComponent)) {
                    SearchEverywhereUI.this.closePopup();
                }
            }
        });
    }

    private void showDescriptionForIndex(int index) {
        SearchEverywhereContributor contributor;
        Object data2;
        if (index >= 0 && !this.myListModel.isMoreElement(index) && (data2 = (contributor = this.myListModel.getContributorForIndex(index)).getDataForItem(this.myListModel.getElementAt(index), SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.getName())) instanceof String) {
            ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, (String)data2);
        }
    }

    private void registerAction(String actionID, Supplier<? extends AnAction> actionSupplier) {
        Optional.ofNullable(ActionManager.getInstance().getAction(actionID)).map(a -> a.getShortcutSet()).ifPresent(shortcuts -> ((AnAction)actionSupplier.get()).registerCustomShortcutSet(shortcuts, (JComponent)((Object)this), (Disposable)this));
    }

    private void registerAction(String actionID, Consumer<? super AnActionEvent> action2) {
        this.registerAction(actionID, () -> DumbAwareAction.create((Consumer)action2));
    }

    private void registerSelectItemAction() {
        int[] allowedModifiers = new int[]{0, 1, 2, 4, 8};
        ShortcutSet selectShortcuts = ActionManager.getInstance().getAction("SearchEverywhere.SelectItem").getShortcutSet();
        Collection keyboardShortcuts = Arrays.stream(selectShortcuts.getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut).map(shortcut -> (KeyboardShortcut)shortcut).collect(Collectors.toList());
        for (int modifiers : allowedModifiers) {
            ArrayList<KeyboardShortcut> newShortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut2 : keyboardShortcuts) {
                KeyStroke originalStroke;
                boolean hasSecondStroke = shortcut2.getSecondKeyStroke() != null;
                KeyStroke keyStroke = originalStroke = hasSecondStroke ? shortcut2.getSecondKeyStroke() : shortcut2.getFirstKeyStroke();
                if ((originalStroke.getModifiers() & modifiers) != 0) continue;
                KeyStroke newStroke = KeyStroke.getKeyStroke(originalStroke.getKeyCode(), originalStroke.getModifiers() | modifiers);
                newShortcuts.add(hasSecondStroke ? new KeyboardShortcut(shortcut2.getFirstKeyStroke(), newStroke) : new KeyboardShortcut(newStroke, null));
            }
            if (newShortcuts.isEmpty()) continue;
            CustomShortcutSet newShortcutSet = new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY));
            DumbAwareAction.create(event -> {
                int[] indices = this.myResultsList.getSelectedIndices();
                this.elementsSelected(indices, modifiers);
            }).registerCustomShortcutSet((ShortcutSet)newShortcutSet, (JComponent)((Object)this), (Disposable)this);
        }
    }

    private void triggerTabSwitched(AnActionEvent e) {
        String id2 = this.mySelectedTab.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
        FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(id2).addInputEvent(e);
        this.featureTriggered("tabSwitched", data2);
    }

    private void fetchGroups(boolean down) {
        int index = this.myResultsList.getSelectedIndex();
        while ((index += down ? 1 : -1) >= 0 && index < this.myListModel.getSize() && !this.myListModel.isGroupFirstItem(index) && !this.myListModel.isMoreElement(index)) {
        }
        if (index >= 0 && index < this.myListModel.getSize()) {
            this.myResultsList.setSelectedIndex(index);
            ScrollingUtil.ensureIndexIsVisible((JList)this.myResultsList, (int)index, (int)0);
        }
    }

    private Optional<SearchEverywhereCommandInfo> getSelectedCommand(String typedCommand) {
        int index = this.myResultsList.getSelectedIndex();
        if (index < 0) {
            return Optional.empty();
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index);
        if (contributor != this.myStubCommandContributor) {
            return Optional.empty();
        }
        SearchEverywhereCommandInfo selectedCommand = (SearchEverywhereCommandInfo)this.myListModel.getElementAt(index);
        return selectedCommand.getCommand().contains(typedCommand) ? Optional.of(selectedCommand) : Optional.empty();
    }

    @NotNull
    private static List<SearchEverywhereCommandInfo> getCommandsForCompletion(Collection<? extends SearchEverywhereContributor<?>> contributors, String enteredCommandPart) {
        Comparator cmdComparator = (cmd1, cmd2) -> {
            String cmdName1 = cmd1.getCommand();
            String cmdName2 = cmd2.getCommand();
            if (!enteredCommandPart.isEmpty()) {
                if (cmdName1.startsWith(enteredCommandPart) && !cmdName2.startsWith(enteredCommandPart)) {
                    return -1;
                }
                if (!cmdName1.startsWith(enteredCommandPart) && cmdName2.startsWith(enteredCommandPart)) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(cmdName1, cmd2.getCommand());
        };
        return contributors.stream().flatMap(contributor -> contributor.getSupportedCommands().stream()).filter(command -> command.getCommand().contains(enteredCommandPart)).sorted(cmdComparator).collect(Collectors.toList());
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        boolean multiSelectMode;
        boolean bl = multiSelectMode = e.isShiftDown() || UIUtil.isControlKeyDown((MouseEvent)e);
        if (e.getButton() == 1 && !multiSelectMode) {
            e.consume();
            int i2 = this.myResultsList.locationToIndex(e.getPoint());
            if (i2 > -1) {
                this.myResultsList.setSelectedIndex(i2);
                this.elementsSelected(new int[]{i2}, e.getModifiers());
            }
        }
    }

    private boolean isHintComponent(Component component2) {
        if (this.myHint != null && !this.myHint.isDisposed() && component2 != null) {
            return SwingUtilities.isDescendingFrom(component2, this.myHint.getContent());
        }
        return false;
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i2 -> !this.myListModel.isMoreElement(i2)).toArray();
        String searchText = this.getSearchPattern();
        if (searchText.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && searchText.contains(" ")) {
            this.featureTriggered("commandUsed", null);
        }
        boolean closePopup = false;
        for (int i3 : indexes) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i3);
            Object value2 = this.myListModel.getElementAt(i3);
            String selectedTabContributorID = this.mySelectedTab.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
            String reportableContributorID = SearchEverywhereUsageTriggerCollector.getReportableContributorID(contributor);
            FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(reportableContributorID, selectedTabContributorID, i3);
            if (value2 instanceof PsiElement) {
                data2.addLanguage(((PsiElement)value2).getLanguage());
            }
            this.featureTriggered("contributorItemChosen", data2);
            closePopup |= contributor.processSelectedItem(value2, modifiers, searchText);
        }
        if (closePopup) {
            this.closePopup();
        } else {
            ApplicationManager.getApplication().invokeLater(() -> this.myResultsList.repaint());
        }
    }

    private void showMoreElements(SearchEverywhereContributor contributor) {
        this.featureTriggered("moreItemChosen", null);
        Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> found = this.myListModel.getFoundElementsMap();
        int limit = this.myListModel.getItemsForContributor(contributor) + (this.mySelectedTab.getContributor().isPresent() ? 30 : 15);
        this.mySearchProgressIndicator = this.mySearcher.findMoreItems(found, this.getSearchPattern(), contributor, limit);
    }

    private void stopSearching() {
        if (this.mySearchProgressIndicator != null && !this.mySearchProgressIndicator.isCanceled()) {
            this.mySearchProgressIndicator.cancel();
        }
        if (this.myBufferedListener != null) {
            this.myBufferedListener.clearBuffer();
        }
    }

    private void closePopup() {
        ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, null);
        this.stopSearching();
        this.searchFinishedHandler.run();
    }

    @NotNull
    private List<SearchEverywhereContributor<?>> getAllTabContributors() {
        return ContainerUtil.filter(this.myShownContributors, contributor -> this.myContributorsFilter.isSelected(contributor.getSearchProviderId()));
    }

    @NotNull
    private Collection<SearchEverywhereContributor<?>> getContributorsForCurrentTab() {
        return this.isAllTabSelected() ? this.getAllTabContributors() : Collections.singleton(this.mySelectedTab.getContributor().get());
    }

    public Future<List<Object>> findElementsForPattern(String pattern) {
        CompletableFuture<List<Object>> future2 = new CompletableFuture<List<Object>>();
        this.mySearchListener.setTestCallback((Consumer<List<Object>>)((Consumer)list2 -> {
            future2.complete((List<Object>)list2);
            this.mySearchListener.setTestCallback(null);
        }));
        this.mySearchField.setText(pattern);
        return future2;
    }

    private String getNotFoundText() {
        return this.mySelectedTab.getContributor().map(c -> IdeBundle.message((String)"searcheverywhere.nothing.found.for.contributor.anywhere", (Object[])new Object[]{c.getFullGroupName().toLowerCase(Locale.ROOT)})).orElse(IdeBundle.message((String)"searcheverywhere.nothing.found.for.all.anywhere", (Object[])new Object[0]));
    }

    private void featureTriggered(@NotNull String featureID, @Nullable FeatureUsageData data2) {
        if (data2 != null) {
            SearchEverywhereUsageTriggerCollector.trigger(this.myProject, featureID, data2);
        } else {
            SearchEverywhereUsageTriggerCollector.trigger(this.myProject, featureID);
        }
    }

    private class SearchListener
    implements SESearcher.Listener {
        private Consumer<List<Object>> testCallback;

        private SearchListener() {
        }

        @Override
        public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            Object prevSelection;
            boolean wasEmpty = SearchEverywhereUI.this.myListModel.listElements.isEmpty();
            SearchEverywhereUI.this.mySelectionTracker.lock();
            SearchEverywhereUI.this.myListModel.addElements(list2);
            SearchEverywhereUI.this.mySelectionTracker.unlock();
            SearchEverywhereUI.this.mySelectionTracker.restoreSelection();
            if (wasEmpty && !SearchEverywhereUI.this.myListModel.listElements.isEmpty() && (prevSelection = ((SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject)).getPrevSelection(SearchEverywhereUI.this.getSelectedContributorID())) instanceof Integer) {
                for (SearchEverywhereFoundElementInfo info : SearchEverywhereUI.this.myListModel.listElements) {
                    if (Objects.hashCode(info.element) != (Integer)prevSelection) continue;
                    SearchEverywhereUI.this.myResultsList.setSelectedValue(info.element, true);
                    break;
                }
            }
        }

        @Override
        public void elementsRemoved(@NotNull List<? extends SearchEverywhereFoundElementInfo> list2) {
            list2.forEach(info -> SearchEverywhereUI.this.myListModel.removeElement(info.getElement(), info.getContributor()));
        }

        @Override
        public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
            if (SearchEverywhereUI.this.myResultsList.isEmpty() || SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                if (SearchEverywhereUI.this.myEverywhereAutoSet && !SearchEverywhereUI.this.isEverywhere() && SearchEverywhereUI.this.canToggleEverywhere() && !SearchEverywhereUI.this.getSearchPattern().isEmpty()) {
                    SearchEverywhereUI.this.setEverywhereAuto(true);
                    SearchEverywhereUI.this.myNotFoundString = SearchEverywhereUI.this.getSearchPattern();
                    return;
                }
                SearchEverywhereUI.this.hideHint();
                if (SearchEverywhereUI.this.myListModel.isResultsExpired()) {
                    SearchEverywhereUI.this.myListModel.clear();
                }
            }
            SearchEverywhereUI.this.myResultsList.setEmptyText(SearchEverywhereUI.this.getSearchPattern().isEmpty() ? "" : SearchEverywhereUI.this.getNotFoundText());
            hasMoreContributors.forEach(SearchEverywhereUI.this.myListModel::setHasMore);
            SearchEverywhereUI.this.mySelectionTracker.resetSelectionIfNeeded();
            if (this.testCallback != null) {
                this.testCallback.consume(SearchEverywhereUI.this.myListModel.getItems());
            }
        }

        void setTestCallback(@Nullable Consumer<List<Object>> callback2) {
            this.testCallback = callback2;
        }
    }

    private class CompleteCommandAction
    extends DumbAwareAction {
        private CompleteCommandAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.completeCommand()) {
                FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(null).addInputEvent(e);
                SearchEverywhereUI.this.featureTriggered("commandCompleted", data2);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.getCompleteCommand().isPresent());
        }

        private boolean completeCommand() {
            Optional<SearchEverywhereCommandInfo> suggestedCommand = this.getCompleteCommand();
            if (suggestedCommand.isPresent()) {
                SearchEverywhereUI.this.mySearchField.setText(suggestedCommand.get().getCommandWithPrefix() + " ");
                return true;
            }
            return false;
        }

        private Optional<SearchEverywhereCommandInfo> getCompleteCommand() {
            String commandPrefix;
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            if (pattern.startsWith(commandPrefix = SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String typedCommand = pattern.substring(commandPrefix.length());
                SearchEverywhereCommandInfo command = SearchEverywhereUI.this.getSelectedCommand(typedCommand).orElseGet(() -> {
                    List completions = SearchEverywhereUI.getCommandsForCompletion(SearchEverywhereUI.this.getContributorsForCurrentTab(), typedCommand);
                    return completions.isEmpty() ? null : (SearchEverywhereCommandInfo)completions.get(0);
                });
                return Optional.ofNullable(command);
            }
            return Optional.empty();
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        ShowInFindToolWindowAction() {
            super(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.description", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchEverywhereUI.this.stopSearching();
            Collection contributors = SearchEverywhereUI.this.getContributorsForCurrentTab();
            contributors = ContainerUtil.filter((Collection)contributors, SearchEverywhereContributor::showInFindResults);
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation2 = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message((String)"searcheverywhere.found.matches.title", (Object[])new Object[]{searchText, contributorsString});
            presentation2.setCodeUsagesString(tabCaptionText);
            presentation2.setUsagesInGeneratedCodeString(IdeBundle.message((String)"searcheverywhere.found.matches.generated.code.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation2.setTargetsNodeText(IdeBundle.message((String)"searcheverywhere.found.targets.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation2.setTabName(tabCaptionText);
            presentation2.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet targets2 = new LinkedHashSet();
            final Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toSet());
            this.fillUsages(cached, usages, targets2);
            final List contributorsForAdditionalSearch = ContainerUtil.filter((Collection)contributors, contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor)contributor));
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run((Task)new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(x0, x1, x2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        this.progressIndicator.start();
                        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(this.progressIndicator);
                        ArrayList<Object> foundElements = new ArrayList<Object>();
                        int alreadyFoundCount = cached.size();
                        for (SearchEverywhereContributor contributor : contributorsForAdditionalSearch) {
                            if (this.progressIndicator.isCanceled()) break;
                            try {
                                this.fetch(contributor, foundElements, alreadyFoundCount, tooManyUsagesStatus);
                            }
                            catch (ProcessCanceledException processCanceledException) {}
                        }
                        ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets2);
                    }

                    <Item> void fetch(SearchEverywhereContributor<Item> contributor, Collection<Object> foundElements, int alreadyFoundCount, TooManyUsagesStatus tooManyUsagesStatus) {
                        contributor.fetchElements(searchText, this.progressIndicator, o -> {
                            if (this.progressIndicator.isCanceled()) {
                                return false;
                            }
                            if (cached.contains(o)) {
                                return true;
                            }
                            foundElements.add(o);
                            tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                            if (foundElements.size() + alreadyFoundCount >= 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)this.progressIndicator, null);
                                return !this.progressIndicator.isCanceled();
                            }
                            return true;
                        });
                    }

                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets2, usages, presentation2);
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        super.onThrowable(error);
                        this.progressIndicator.cancel();
                    }
                });
            } else {
                this.showInFindWindow(targets2, usages, presentation2);
            }
            SearchEverywhereUI.this.closePopup();
        }

        private void fillUsages(Collection<Object> foundElements, Collection<? super Usage> usages, Collection<? super PsiElement> targets2) {
            ReadAction.run(() -> foundElements.stream().filter(o -> o instanceof PsiElement).forEach(o -> {
                PsiElement element2 = (PsiElement)o;
                if (element2.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo(element2);
                    usages.add((Usage)new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets2.add(element2);
                }
            }));
        }

        private void showInFindWindow(Collection<? extends PsiElement> targets2, Collection<Usage> usages, UsageViewPresentation presentation2) {
            UsageTarget[] targetsArray = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets2));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance((Project)SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (SearchEverywhereUI.this.myProject == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            SearchEverywhereContributor<?> contributor = SearchEverywhereUI.this.mySelectedTab == null ? null : ((SearchEverywhereUI)SearchEverywhereUI.this).mySelectedTab.contributor;
            e.getPresentation().setEnabled(contributor == null || contributor.showInFindResults());
            e.getPresentation().setIcon(ToolWindowManager.getInstance((Project)SearchEverywhereUI.this.myProject).getLocationIcon("Find", AllIcons.General.Pin_tab));
        }
    }

    public static class SearchListModel
    extends AbstractListModel<Object> {
        static final Object MORE_ELEMENT = new Object();
        private final List<SearchEverywhereFoundElementInfo> listElements = new ArrayList<SearchEverywhereFoundElementInfo>();
        private boolean resultsExpired = false;

        public boolean isResultsExpired() {
            return this.resultsExpired;
        }

        public void expireResults() {
            this.resultsExpired = true;
        }

        @Override
        public int getSize() {
            return this.listElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.listElements.get(index).getElement();
        }

        public List<Object> getItems() {
            return new ArrayList<Object>(this.values());
        }

        public Collection<Object> getFoundItems(SearchEverywhereContributor contributor) {
            return this.listElements.stream().filter(info -> info.getContributor() == contributor && info.getElement() != MORE_ELEMENT).map(info -> info.getElement()).collect(Collectors.toList());
        }

        public boolean hasMoreElements(SearchEverywhereContributor contributor) {
            return this.listElements.stream().anyMatch(info -> info.getElement() == MORE_ELEMENT && info.getContributor() == contributor);
        }

        public void addElements(List<? extends SearchEverywhereFoundElementInfo> items) {
            if (items.isEmpty()) {
                return;
            }
            HashMap<SearchEverywhereContributor, List> itemsMap = new HashMap<SearchEverywhereContributor, List>();
            items.forEach(info -> {
                List list2 = itemsMap.computeIfAbsent(info.getContributor(), contributor -> new ArrayList());
                list2.add(info);
            });
            itemsMap.forEach((contributor, list2) -> list2.sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed()));
            if (this.resultsExpired) {
                this.retainContributors(itemsMap.keySet());
                this.clearMoreItems();
                itemsMap.forEach((contributor, list2) -> {
                    Object[] oldItems = ArrayUtil.toObjectArray(this.getFoundItems((SearchEverywhereContributor)contributor));
                    Object[] newItems = list2.stream().map(SearchEverywhereFoundElementInfo::getElement).toArray();
                    try {
                        Diff.Change change = Diff.buildChanges((Object[])oldItems, (Object[])newItems);
                        this.applyChange(change, (SearchEverywhereContributor<?>)contributor, (List<SearchEverywhereFoundElementInfo>)list2);
                    }
                    catch (FilesTooBigForDiffException e) {
                        LOG.error("Cannot calculate diff for updated search results");
                    }
                });
                this.resultsExpired = false;
            } else {
                itemsMap.forEach((contributor, list2) -> {
                    int startIndex = this.contributors().indexOf(contributor);
                    int insertionIndex = this.getInsertionPoint((SearchEverywhereContributor)contributor);
                    int endIndex = insertionIndex + list2.size() - 1;
                    this.listElements.addAll(insertionIndex, (Collection<SearchEverywhereFoundElementInfo>)list2);
                    this.fireIntervalAdded(this, insertionIndex, endIndex);
                    if (startIndex >= 0) {
                        this.listElements.subList(startIndex, endIndex + 1).sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed());
                        this.fireContentsChanged(this, startIndex, endIndex);
                    }
                });
            }
        }

        private void retainContributors(Collection<SearchEverywhereContributor<?>> retainContributors) {
            Iterator<SearchEverywhereFoundElementInfo> iterator2 = this.listElements.iterator();
            int startInterval = 0;
            int endInterval = -1;
            while (iterator2.hasNext()) {
                SearchEverywhereFoundElementInfo item = iterator2.next();
                if (retainContributors.contains(item.getContributor())) {
                    if (startInterval <= endInterval) {
                        this.fireIntervalRemoved(this, startInterval, endInterval);
                        startInterval = endInterval + 2;
                    } else {
                        ++startInterval;
                    }
                } else {
                    iterator2.remove();
                }
                ++endInterval;
            }
            if (startInterval <= endInterval) {
                this.fireIntervalRemoved(this, startInterval, endInterval);
            }
        }

        private void clearMoreItems() {
            ListIterator<SearchEverywhereFoundElementInfo> iterator2 = this.listElements.listIterator();
            while (iterator2.hasNext()) {
                int index = iterator2.nextIndex();
                if (iterator2.next().getElement() != MORE_ELEMENT) continue;
                iterator2.remove();
                this.fireContentsChanged(this, index, index);
            }
        }

        private void applyChange(Diff.Change change, SearchEverywhereContributor<?> contributor, List<SearchEverywhereFoundElementInfo> newItems) {
            int firstItemIndex = this.contributors().indexOf(contributor);
            if (firstItemIndex < 0) {
                firstItemIndex = this.getInsertionPoint(contributor);
            }
            for (Diff.Change ch : SearchListModel.toRevertedList(change)) {
                if (ch.deleted > 0) {
                    for (int i2 = ch.deleted - 1; i2 >= 0; --i2) {
                        int index = firstItemIndex + ch.line0 + i2;
                        this.listElements.remove(index);
                    }
                    this.fireIntervalRemoved(this, firstItemIndex + ch.line0, firstItemIndex + ch.line0 + ch.deleted - 1);
                }
                if (ch.inserted <= 0) continue;
                List<SearchEverywhereFoundElementInfo> addedItems = newItems.subList(ch.line1, ch.line1 + ch.inserted);
                this.listElements.addAll(firstItemIndex + ch.line0, addedItems);
                this.fireIntervalAdded(this, firstItemIndex + ch.line0, firstItemIndex + ch.line0 + ch.inserted - 1);
            }
        }

        private static List<Diff.Change> toRevertedList(Diff.Change change) {
            ArrayList<Diff.Change> res2 = new ArrayList<Diff.Change>();
            while (change != null) {
                res2.add(0, change);
                change = change.link;
            }
            return res2;
        }

        public void removeElement(@NotNull Object item, SearchEverywhereContributor contributor) {
            int index = this.contributors().indexOf(contributor);
            if (index < 0) {
                return;
            }
            while (index < this.listElements.size() && this.listElements.get(index).getContributor() == contributor) {
                if (item.equals(this.listElements.get(index).getElement())) {
                    this.listElements.remove(index);
                    this.fireIntervalRemoved(this, index, index);
                    return;
                }
                ++index;
            }
        }

        public void setHasMore(SearchEverywhereContributor<?> contributor, boolean newVal) {
            int index = this.contributors().lastIndexOf(contributor);
            if (index < 0) {
                return;
            }
            boolean alreadyHas = this.isMoreElement(index);
            if (alreadyHas && !newVal) {
                this.listElements.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
            if (!alreadyHas && newVal) {
                this.listElements.add(++index, new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, contributor));
                this.fireIntervalAdded(this, index, index);
            }
        }

        public void clear() {
            int index = this.listElements.size() - 1;
            this.listElements.clear();
            if (index >= 0) {
                this.fireIntervalRemoved(this, 0, index);
            }
        }

        public boolean contains(Object val) {
            return this.values().contains(val);
        }

        public boolean isMoreElement(int index) {
            return this.listElements.get(index).getElement() == MORE_ELEMENT;
        }

        public <Item> SearchEverywhereContributor<Item> getContributorForIndex(int index) {
            return this.listElements.get(index).getContributor();
        }

        public boolean isGroupFirstItem(int index) {
            return index == 0 || this.listElements.get(index).getContributor() != this.listElements.get(index - 1).getContributor();
        }

        public int getItemsForContributor(SearchEverywhereContributor<?> contributor) {
            List<SearchEverywhereContributor> contributorsList = this.contributors();
            int first = contributorsList.indexOf(contributor);
            int last = contributorsList.lastIndexOf(contributor);
            if (this.isMoreElement(last)) {
                --last;
            }
            return last - first + 1;
        }

        public Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> getFoundElementsMap() {
            return this.listElements.stream().filter(info -> info.element != MORE_ELEMENT).collect(Collectors.groupingBy(o -> o.getContributor(), Collectors.toCollection(ArrayList::new)));
        }

        @NotNull
        private List<SearchEverywhereContributor> contributors() {
            return Lists.transform(this.listElements, info -> info.getContributor());
        }

        @NotNull
        private List<Object> values() {
            return Lists.transform(this.listElements, info -> info.getElement());
        }

        private int getInsertionPoint(SearchEverywhereContributor contributor) {
            if (this.listElements.isEmpty()) {
                return 0;
            }
            List<SearchEverywhereContributor> list2 = this.contributors();
            int index = list2.lastIndexOf(contributor);
            if (index >= 0) {
                return this.isMoreElement(index) ? index : index + 1;
            }
            index = Collections.binarySearch(list2, contributor, Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
            return -index - 1;
        }
    }

    private static class GroupTitleRenderer
    extends CellRendererPanel {
        final SimpleColoredComponent titleLabel = new SimpleColoredComponent();

        GroupTitleRenderer() {
            this.setLayout(new BorderLayout());
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.BigPopup.listSeparatorColor(), null);
            JBPanel topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)0).addToCenter((Component)separatorComponent).addToLeft((Component)this.titleLabel).withBorder((Border)JBUI.Borders.empty((int)1, (int)7))).withBackground(UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(String title, Component itemContent) {
            this.titleLabel.clear();
            this.titleLabel.append(title, SMALL_LABEL_ATTRS);
            Component prevContent = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            this.accessibleContext = itemContent.getAccessibleContext();
            return this;
        }
    }

    private class CompositeCellRenderer
    implements ListCellRenderer<Object> {
        private CompositeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Border border;
            if (value2 == SearchListModel.MORE_ELEMENT) {
                Component component2 = SearchEverywhereUI.this.myMoreRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                component2.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component2.getPreferredSize()));
                return component2;
            }
            SearchEverywhereContributor contributor = SearchEverywhereUI.this.myListModel.getContributorForIndex(index);
            Object component3 = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            if (component3 == null) {
                component3 = contributor.getElementsRenderer().getListCellRendererComponent(list2, value2, index, isSelected, true);
            }
            if (component3 instanceof JComponent && (border = ((JComponent)component3).getBorder()) != GotoActionModel.GotoActionListCellRenderer.TOGGLE_BUTTON_BORDER) {
                ((JComponent)component3).setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
            }
            AppUIUtil.targetToDevice(component3, list2);
            component3.setPreferredSize(UIUtil.updateListRowHeight((Dimension)component3.getPreferredSize()));
            if (SearchEverywhereUI.this.isAllTabSelected() && SearchEverywhereUI.this.myListModel.isGroupFirstItem(index)) {
                component3 = SearchEverywhereUI.this.myGroupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), (Component)component3);
            }
            return component3;
        }
    }

    private class SETab
    extends JLabel {
        final SearchEverywhereContributor<?> contributor;
        final List<AnAction> actions;
        final SearchEverywhereToggleAction everywhereAction;

        SETab(SearchEverywhereContributor<?> contributor) {
            super(contributor == null ? IdeBundle.message((String)"searcheverywhere.allelements.tab.name", (Object[])new Object[0]) : contributor.getGroupName());
            this.contributor = contributor;
            this.updateTooltip();
            final Runnable onChanged = () -> {
                SearchEverywhereUI.this.myToolbar.updateActionsImmediately();
                SearchEverywhereUI.this.scheduleRebuildList();
            };
            if (contributor == null) {
                String actionText = IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.items", new Object[0]);
                this.actions = Arrays.asList(new AnAction[]{new CheckBoxSearchEverywhereToggleAction(actionText){
                    final SearchEverywhereManagerImpl seManager;
                    {
                        super(text);
                        this.seManager = (SearchEverywhereManagerImpl)SearchEverywhereManager.getInstance(SearchEverywhereUI.this.myProject);
                    }

                    public boolean isEverywhere() {
                        return this.seManager.isEverywhere();
                    }

                    public void setEverywhere(boolean state) {
                        this.seManager.setEverywhere(state);
                        SearchEverywhereUI.this.myTabs.stream().filter(tab -> tab != SETab.this).forEach(tab -> tab.everywhereAction.setEverywhere(state));
                        onChanged.run();
                    }
                }, new SearchEverywhereUIBase.FiltersAction(SearchEverywhereUI.this.myContributorsFilter, onChanged)});
            } else {
                this.actions = new ArrayList<AnAction>(contributor.getActions(onChanged));
            }
            this.everywhereAction = (SearchEverywhereToggleAction)ContainerUtil.find(this.actions, o -> o instanceof SearchEverywhereToggleAction);
            Insets insets = JBUI.CurrentTheme.BigPopup.tabInsets();
            this.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchEverywhereUI.this.switchToTab(SETab.this);
                    String reportableID = SETab.this.getContributor().map(SearchEverywhereUsageTriggerCollector::getReportableContributorID).orElse("SearchEverywhereContributor.All");
                    FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(reportableID).addInputEvent(e);
                    SearchEverywhereUI.this.featureTriggered("tabSwitched", data2);
                }
            });
        }

        private void updateTooltip() {
            String shortcut = (String)SearchEverywhereUI.this.myShortcutSupplier.apply(this.getID());
            if (shortcut != null) {
                this.setToolTipText(shortcut);
            }
        }

        public String getID() {
            return this.getContributor().map(SearchEverywhereContributor::getSearchProviderId).orElse("SearchEverywhereContributor.All");
        }

        public Optional<SearchEverywhereContributor<?>> getContributor() {
            return Optional.ofNullable(this.contributor);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUIScale.scale((int)29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return SearchEverywhereUI.this.mySelectedTab == this;
        }

        @Override
        public Color getBackground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabColor() : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabTextColor() : super.getForeground();
        }
    }
}

