/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsSEContributor
implements SearchEverywhereContributor<ChooseRunConfigurationPopup.ItemWrapper> {
    private final SearchEverywhereCommandInfo RUN_COMMAND = new SearchEverywhereCommandInfo("run", IdeBundle.message((String)"searcheverywhere.runconfigurations.command.run.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    private final SearchEverywhereCommandInfo DEBUG_COMMAND = new SearchEverywhereCommandInfo("debug", IdeBundle.message((String)"searcheverywhere.runconfigurations.command.debug.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    private static final int RUN_MODE = 0;
    private static final int DEBUG_MODE = 1;
    private final Project myProject;
    private final Component myContextComponent;
    private final Supplier<String> myCommandSupplier;
    private final Renderer renderer = new Renderer();

    public RunConfigurationsSEContributor(Project project, Component component2, Supplier<String> commandSupplier) {
        this.myProject = project;
        this.myContextComponent = component2;
        this.myCommandSupplier = commandSupplier;
    }

    @NotNull
    public String getSearchProviderId() {
        return this.getClass().getSimpleName();
    }

    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"searcheverywhere.run.configs.tab.name", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 350;
    }

    public boolean showInFindResults() {
        return false;
    }

    public boolean processSelectedItem(@NotNull ChooseRunConfigurationPopup.ItemWrapper selected2, int modifiers, @NotNull String searchText) {
        int mode;
        Executor executor;
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast(selected2.getValue(), RunnerAndConfigurationSettings.class);
        if (settings != null && (executor = RunConfigurationsSEContributor.findExecutor(settings, mode = this.getMode(searchText, modifiers))) != null) {
            DataManager dataManager = DataManager.getInstance();
            selected2.perform(this.myProject, executor, dataManager.getDataContext(this.myContextComponent));
        }
        return true;
    }

    @Nullable
    public Object getDataForItem(@NotNull ChooseRunConfigurationPopup.ItemWrapper element2, @NotNull String dataId) {
        return null;
    }

    @NotNull
    public ListCellRenderer<? super ChooseRunConfigurationPopup.ItemWrapper> getElementsRenderer() {
        return this.renderer;
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        return Arrays.asList(this.RUN_COMMAND, this.DEBUG_COMMAND);
    }

    public void fetchElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super ChooseRunConfigurationPopup.ItemWrapper> consumer) {
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        pattern = this.filterString(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)pattern).build();
        for (ChooseRunConfigurationPopup.ItemWrapper wrapper2 : ChooseRunConfigurationPopup.createFlatSettingsList(this.myProject)) {
            if (!matcher.matches(wrapper2.getText()) || consumer.process((Object)wrapper2)) continue;
            return;
        }
    }

    private int getMode(String searchText, int modifiers) {
        if (RunConfigurationsSEContributor.isCommand(searchText, this.DEBUG_COMMAND)) {
            return 1;
        }
        if (RunConfigurationsSEContributor.isCommand(searchText, this.RUN_COMMAND)) {
            return 0;
        }
        return (modifiers & 1) == 0 ? 1 : 0;
    }

    private static Optional<String> extractFirstWord(String input) {
        if (!StringUtil.isEmptyOrSpaces((String)input) && input.contains(" ")) {
            return Optional.of(input.split(" ")[0]);
        }
        return Optional.empty();
    }

    private String filterString(String input) {
        return RunConfigurationsSEContributor.extractFirstWord(input).filter(firstWord -> this.RUN_COMMAND.getCommandWithPrefix().startsWith((String)firstWord) || this.DEBUG_COMMAND.getCommandWithPrefix().startsWith((String)firstWord)).map(firstWord -> input.substring(firstWord.length() + 1)).orElse(input);
    }

    private static boolean isCommand(String input, SearchEverywhereCommandInfo command) {
        if (input == null) {
            return false;
        }
        return RunConfigurationsSEContributor.extractFirstWord(input).map(firstWord -> command.getCommandWithPrefix().startsWith((String)firstWord)).orElse(false);
    }

    @Nullable
    private static Executor findExecutor(@NotNull RunnerAndConfigurationSettings settings, int mode) {
        Executor executor;
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
        Executor executor2 = executor = mode == 0 ? runExecutor : debugExecutor;
        if (executor == null) {
            return null;
        }
        RunConfiguration runConf = settings.getConfiguration();
        if (ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConf) == null) {
            executor = runExecutor == executor ? debugExecutor : runExecutor;
        }
        return executor;
    }

    private class Renderer
    extends JPanel
    implements ListCellRenderer<ChooseRunConfigurationPopup.ItemWrapper> {
        private final SimpleColoredComponent runConfigInfo;
        private final SimpleColoredComponent executorInfo;

        private Renderer() {
            super(new BorderLayout());
            this.runConfigInfo = new SimpleColoredComponent();
            this.executorInfo = new SimpleColoredComponent();
            this.add((Component)this.runConfigInfo, "Center");
            this.add((Component)this.executorInfo, "East");
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)(UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale((int)UIUtil.getListCellHPadding()))));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ChooseRunConfigurationPopup.ItemWrapper> list2, ChooseRunConfigurationPopup.ItemWrapper wrapper2, int index, boolean isSelected, boolean cellHasFocus) {
            this.runConfigInfo.clear();
            this.executorInfo.clear();
            this.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.setFont(list2.getFont());
            Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
            this.runConfigInfo.append(wrapper2.getText(), new SimpleTextAttributes(0, foreground));
            this.runConfigInfo.setIcon(wrapper2.getIcon());
            this.fillExecutorInfo(wrapper2, list2, isSelected);
            return this;
        }

        private void fillExecutorInfo(ChooseRunConfigurationPopup.ItemWrapper wrapper2, JList<?> list2, boolean selected2) {
            SimpleTextAttributes commandAttributes = selected2 ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            SimpleTextAttributes shortcutAttributes = selected2 ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAY_ATTRIBUTES;
            String input = (String)RunConfigurationsSEContributor.this.myCommandSupplier.get();
            if (RunConfigurationsSEContributor.isCommand(input, RunConfigurationsSEContributor.this.RUN_COMMAND)) {
                this.fillWithMode(wrapper2, 0, commandAttributes);
                return;
            }
            if (RunConfigurationsSEContributor.isCommand(input, RunConfigurationsSEContributor.this.DEBUG_COMMAND)) {
                this.fillWithMode(wrapper2, 1, commandAttributes);
                return;
            }
            Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
            Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
            KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
            KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
            if (debugExecutor != null) {
                this.executorInfo.append(debugExecutor.getId(), commandAttributes);
                this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")", shortcutAttributes);
                if (runExecutor != null) {
                    this.executorInfo.append(" / " + runExecutor.getId(), commandAttributes);
                    this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)shiftEnterStroke) + ")", shortcutAttributes);
                }
            } else if (runExecutor != null) {
                this.executorInfo.append(runExecutor.getId(), commandAttributes);
                this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")", shortcutAttributes);
            }
        }

        private void fillWithMode(ChooseRunConfigurationPopup.ItemWrapper wrapper2, int mode, SimpleTextAttributes attributes) {
            Optional.ofNullable(ObjectUtils.tryCast(wrapper2.getValue(), RunnerAndConfigurationSettings.class)).map(settings -> RunConfigurationsSEContributor.findExecutor(settings, mode)).ifPresent(executor -> {
                this.executorInfo.append(executor.getId(), attributes);
                this.executorInfo.setIcon(executor.getToolWindowIcon());
            });
        }
    }
}

