/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class RecentFilesSEContributor
extends FileSearchEverywhereContributor {
    public RecentFilesSEContributor(@NotNull AnActionEvent event) {
        super(event);
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        return RecentFilesSEContributor.class.getSimpleName();
    }

    @Override
    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"search.everywhere.group.name.recent.files", (Object[])new Object[0]);
    }

    @Override
    public int getSortWeight() {
        return 70;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        return super.getElementPriority(element2, searchPattern) + 5;
    }

    @Override
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super FoundItemDescriptor<Object>> consumer) {
        if (this.myProject == null) {
            return;
        }
        String searchString = this.filterControlSymbols(pattern);
        boolean preferStartMatches = !searchString.startsWith("*");
        MinusculeMatcher matcher = RecentFilesSEContributor.createMatcher(searchString, preferStartMatches);
        List<VirtualFile> opened = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles());
        List history = Lists.reverse(EditorHistoryManager.getInstance(this.myProject).getFileList());
        ArrayList res2 = new ArrayList();
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Stream<Object> stream = history.stream();
            if (!StringUtil.isEmptyOrSpaces((String)searchString)) {
                stream = stream.filter(file2 -> matcher.matches(file2.getName()));
            }
            res2.addAll(stream.filter(vf -> !opened.contains(vf) && vf.isValid()).distinct().map(vf -> {
                PsiFile f = psiManager.findFile(vf);
                String name = vf.getName();
                return f == null ? null : new FoundItemDescriptor((Object)f, matcher.matchingDegree(name));
            }).filter(file2 -> file2 != null).collect(Collectors.toList()));
            ContainerUtil.process((List)res2, (Processor)consumer);
        }, progressIndicator2);
    }

    private static MinusculeMatcher createMatcher(String searchString, boolean preferStartMatches) {
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)("*" + searchString));
        if (preferStartMatches) {
            builder2 = builder2.preferringStartMatches();
        }
        return builder2.build();
    }

    public boolean isEmptyPatternSupported() {
        return true;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return false;
    }
}

