/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PersistentSearchEverywhereContributorFilter<T> {
    private final ChooseByNameFilterConfiguration<? super T> myPersistentConfiguration;
    private final List<T> myElements;
    private final Function<? super T, String> myTextExtractor;
    private final Function<? super T, ? extends Icon> myIconExtractor;

    public PersistentSearchEverywhereContributorFilter(@NotNull List<T> elements2, @NotNull ChooseByNameFilterConfiguration<? super T> configuration, Function<? super T, String> textExtractor, Function<? super T, ? extends Icon> iconExtractor) {
        this.myElements = elements2;
        this.myPersistentConfiguration = configuration;
        this.myTextExtractor = textExtractor;
        this.myIconExtractor = iconExtractor;
    }

    public List<T> getAllElements() {
        return this.myElements;
    }

    public List<T> getSelectedElements() {
        return ContainerUtil.filter(this.myElements, this.myPersistentConfiguration::isFileTypeVisible);
    }

    public boolean isSelected(T element2) {
        return this.myPersistentConfiguration.isFileTypeVisible(element2);
    }

    public void setSelected(T element2, boolean selected2) {
        this.myPersistentConfiguration.setVisible(element2, selected2);
    }

    public String getElementText(T element2) {
        return this.myTextExtractor.apply(element2);
    }

    public Icon getElementIcon(T element2) {
        return this.myIconExtractor.apply(element2);
    }
}

