/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingGroup {
    public static final Function<String, NameUtil.MatcherBuilder> RUN_ANYTHING_MATCHER_BUILDER = pattern -> NameUtil.buildMatcher((String)("*" + pattern));
    volatile int myMoreIndex = -1;
    volatile int myTitleIndex = -1;

    @NotNull
    public abstract String getTitle();

    protected int getMaxInitialItems() {
        return 5;
    }

    public int getMaxItemsToInsert() {
        return 5;
    }

    public abstract SearchResult getItems(@NotNull DataContext var1, @NotNull List<RunAnythingItem> var2, @NotNull String var3, int var4);

    public void resetMoreIndex() {
        this.myMoreIndex = -1;
    }

    private static void shiftMoreIndex(Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myMoreIndex >= baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myMoreIndex += shift);
    }

    @Nullable
    public static String getTitle(@NotNull Collection<? extends RunAnythingGroup> groups, int titleIndex) {
        return Optional.ofNullable(RunAnythingGroup.findGroup(groups, titleIndex)).map(RunAnythingGroup::getTitle).orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findGroup(@NotNull Collection<? extends RunAnythingGroup> groups, int titleIndex) {
        return groups.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findItemGroup(@NotNull List<? extends RunAnythingGroup> groups, int itemIndex) {
        RunAnythingGroup runAnythingGroup = null;
        for (RunAnythingGroup runAnythingGroup2 : groups) {
            if (runAnythingGroup2.myTitleIndex == -1) continue;
            if (runAnythingGroup2.myTitleIndex > itemIndex) break;
            runAnythingGroup = runAnythingGroup2;
        }
        return runAnythingGroup;
    }

    private static void shiftTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myTitleIndex != -1 && runAnythingGroup.myTitleIndex > baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myTitleIndex += shift);
    }

    public static void clearMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups) {
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myMoreIndex = -1;
        });
    }

    private static void clearTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups) {
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myTitleIndex = -1;
        });
    }

    public static int[] getAllIndexes(@NotNull Collection<? extends RunAnythingGroup> groups) {
        TIntArrayList list2 = new TIntArrayList();
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myTitleIndex);
        }
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myMoreIndex);
        }
        return list2.toNativeArray();
    }

    @Nullable
    public static RunAnythingGroup findGroupByMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int moreIndex) {
        return groups.stream().filter(runAnythingGroup -> moreIndex == runAnythingGroup.myMoreIndex).findFirst().orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findGroupByTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int titleIndex) {
        return groups.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().orElse(null);
    }

    public static boolean isMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int index) {
        return groups.stream().anyMatch(runAnythingGroup -> runAnythingGroup.myMoreIndex == index);
    }

    public static void shiftIndexes(@NotNull Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        RunAnythingGroup.shiftTitleIndex(groups, baseIndex, shift);
        RunAnythingGroup.shiftMoreIndex(groups, baseIndex, shift);
    }

    public static void clearIndexes(@NotNull Collection<? extends RunAnythingGroup> groups) {
        RunAnythingGroup.clearTitleIndex(groups);
        RunAnythingGroup.clearMoreIndex(groups);
    }

    public final synchronized void collectItems(@NotNull DataContext dataContext, @NotNull List<RunAnythingItem> model, @NotNull String pattern) {
        SearchResult result2 = this.getItems(dataContext, model, pattern, this.getMaxInitialItems());
        ProgressManager.checkCanceled();
        if (!result2.isEmpty()) {
            this.myTitleIndex = model.size();
            model.addAll(result2);
            this.myMoreIndex = result2.myNeedMore ? model.size() - 1 : -1;
        }
    }

    public static class SearchResult
    extends ArrayList<RunAnythingItem> {
        boolean myNeedMore;

        public boolean isNeedMore() {
            return this.myNeedMore;
        }

        public void setNeedMore(boolean needMore) {
            this.myNeedMore = needMore;
        }
    }
}

