/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingPopupUI;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingRecentGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RunAnythingCalcThread
implements Computable<RunAnythingSearchListModel> {
    @NotNull
    private final String myPattern;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final Project myProject;

    RunAnythingCalcThread(@NotNull Project project, @NotNull DataContext context, @NotNull String pattern) {
        this.myProject = project;
        this.myPattern = pattern;
        this.myDataContext = context;
    }

    public RunAnythingSearchListModel compute() {
        RunAnythingSearchListModel model;
        if (RunAnythingPopupUI.isHelpMode(this.myPattern)) {
            model = new RunAnythingSearchListModel.RunAnythingHelpListModel();
            List<RunAnythingItem> items = this.buildHelpGroups((RunAnythingSearchListModel.RunAnythingHelpListModel)model);
            model.addAll(0, items);
        } else {
            model = new RunAnythingSearchListModel.RunAnythingMainListModel();
            List<RunAnythingItem> items = this.buildAllGroups(model);
            model.addAll(0, items);
            this.loadEntireSingleMatchedGroup(model, items);
        }
        return model;
    }

    private void loadEntireSingleMatchedGroup(@NotNull RunAnythingSearchListModel model, @NotNull List<RunAnythingItem> items) {
        RunAnythingGroup titleGroup = null;
        RunAnythingGroup moreGroup = null;
        int index = 0;
        for (int i2 = 0; i2 < items.size(); ++i2) {
            RunAnythingGroup currentTitleGroup = model.findGroupByTitleIndex(i2);
            if (currentTitleGroup instanceof RunAnythingRecentGroup) continue;
            if (currentTitleGroup != null) {
                if (titleGroup == null) {
                    titleGroup = currentTitleGroup;
                } else {
                    return;
                }
            }
            if ((moreGroup = model.findGroupByMoreIndex(i2)) == null) continue;
            if (moreGroup instanceof RunAnythingRecentGroup) {
                moreGroup = null;
                continue;
            }
            index = i2;
        }
        if (moreGroup != null) {
            RunAnythingPopupUI.insert(moreGroup, model, this.myDataContext, this.myPattern, index, 100);
        }
    }

    @NotNull
    private List<RunAnythingItem> buildHelpGroups(@NotNull RunAnythingSearchListModel.RunAnythingHelpListModel model) {
        ArrayList<RunAnythingItem> items = new ArrayList<RunAnythingItem>();
        model.getGroups().forEach(group -> group.collectItems(this.myDataContext, items, RunAnythingPopupUI.trimHelpPattern(this.myPattern)));
        return items;
    }

    @NotNull
    private List<RunAnythingItem> buildAllGroups(@NotNull RunAnythingSearchListModel model) {
        ArrayList<RunAnythingItem> items = new ArrayList<RunAnythingItem>();
        if (this.myPattern.trim().length() == 0) {
            RunAnythingGroup recentGroup = model.getGroups().stream().filter(group -> group instanceof RunAnythingRecentGroup).findFirst().orElse(null);
            assert (recentGroup != null);
            recentGroup.collectItems(this.myDataContext, items, this.myPattern);
        } else {
            this.buildCompletionGroups(this.myDataContext, items, model);
        }
        return items;
    }

    private void buildCompletionGroups(@NotNull DataContext dataContext, @NotNull List<RunAnythingItem> items, @NotNull RunAnythingSearchListModel model) {
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            return;
        }
        model.getGroups().stream().filter(group -> group instanceof RunAnythingCompletionGroup || group instanceof RunAnythingGeneralGroup || group instanceof RunAnythingRecentGroup).filter(group -> RunAnythingCache.getInstance(this.myProject).isGroupVisible((RunAnythingGroup)group)).forEach(group -> group.collectItems(dataContext, items, this.myPattern));
    }
}

