/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.newclass;

import com.intellij.ide.ui.newItemPopup.NewItemWithTemplatesPopupPanel;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateWithTemplatesDialogPanel
extends NewItemWithTemplatesPopupPanel<Trinity<String, Icon, String>> {
    public CreateWithTemplatesDialogPanel(@NotNull List<Trinity<String, Icon, String>> templates, @Nullable String selectedItem) {
        super(templates, new TemplateListCellRenderer());
        this.myTemplatesList.addListSelectionListener(e -> {
            Trinity selectedValue = (Trinity)this.myTemplatesList.getSelectedValue();
            if (selectedValue != null) {
                this.setTextFieldIcon((Icon)selectedValue.second);
            }
        });
        this.selectTemplate(selectedItem);
        this.setTemplatesListVisible(templates.size() > 1);
    }

    public JTextField getNameField() {
        return this.myTextField;
    }

    @NotNull
    public String getEnteredName() {
        return this.myTextField.getText().trim();
    }

    @NotNull
    public String getSelectedTemplate() {
        return (String)((Trinity)this.myTemplatesList.getSelectedValue()).third;
    }

    private void setTextFieldIcon(Icon icon2) {
        this.myTextField.setExtensions(new ExtendableTextComponent.Extension[]{new TemplateIconExtension(icon2)});
        this.myTextField.repaint();
    }

    private void selectTemplate(@Nullable String selectedItem) {
        ListModel model = this.myTemplatesList.getModel();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            String templateID = (String)((Trinity)model.getElementAt(i2)).getThird();
            if (!StringUtil.equals((CharSequence)selectedItem, (CharSequence)templateID)) continue;
            this.myTemplatesList.setSelectedIndex(i2);
            return;
        }
        this.myTemplatesList.setSelectedIndex(0);
    }

    private static class TemplateIconExtension
    implements ExtendableTextComponent.Extension {
        private final Icon icon;

        private TemplateIconExtension(Icon icon2) {
            this.icon = icon2;
        }

        public Icon getIcon(boolean hovered2) {
            return this.icon;
        }

        public boolean isIconBeforeText() {
            return true;
        }
    }

    private static class TemplateListCellRenderer
    implements ListCellRenderer<Trinity<String, Icon, String>> {
        private final ListCellRenderer<Trinity<String, Icon, String>> delegateRenderer = SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 != null) {
                label2.setText((String)value2.first);
                label2.setIcon((Icon)value2.second);
            }
        });

        private TemplateListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Trinity<String, Icon, String>> list2, Trinity<String, Icon, String> value2, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent delegate = (JComponent)this.delegateRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            delegate.setBorder((Border)JBUI.Borders.empty((int)JBUIScale.scale((int)3), (int)JBUIScale.scale((int)1)));
            return delegate;
        }
    }
}

