/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WeighingActionGroup
extends ActionGroup {
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    WeighingActionGroup() {
    }

    public void update(@NotNull AnActionEvent e) {
        this.getDelegate().update(e);
    }

    protected abstract ActionGroup getDelegate();

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        ActionGroup delegate = this.getDelegate();
        AnAction[] children2 = delegate.getChildren(e);
        if (e == null) {
            return children2;
        }
        List<AnAction> visibleActions = Utils.expandActionGroup(false, delegate, this.myPresentationFactory, e.getDataContext(), e.getPlace());
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action2 : visibleActions) {
            Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
            if (!presentation2.isEnabled() || !presentation2.isVisible()) continue;
            if (presentation2.getWeight() > maxWeight) {
                maxWeight = presentation2.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation2.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action2);
        }
        if (heaviest == null) {
            return children2;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action3 : visibleActions) {
            boolean separator = action3 instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action3);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action3)) {
                heaviest.add(action3);
            }
            if (!heaviest.contains(action3)) continue;
            chosen.add(action3);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(delegate, heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.WeighingActionGroup.text", (Object[])new Object[0]));
        return new AnAction[]{chosen, new Separator(), other};
    }

    protected boolean shouldBeChosenAnyway(AnAction action2) {
        return false;
    }
}

