/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Font;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TogglePresentationModeAction
extends AnAction
implements DumbAware {
    private static final Map<Object, Object> ourSavedValues = new LinkedHashMap<Object, Object>();
    private static float ourSavedScaleFactor = JBUIScale.scale((float)1.0f);
    private static int ourSavedConsoleFontSize;

    public void update(@NotNull AnActionEvent e) {
        boolean selected2 = UISettings.getInstance().getPresentationMode();
        e.getPresentation().setText(selected2 ? ActionsBundle.message((String)"action.TogglePresentationMode.exit", (Object[])new Object[0]) : ActionsBundle.message((String)"action.TogglePresentationMode.enter", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        UISettings settings = UISettings.getInstance();
        Project project = e.getProject();
        TogglePresentationModeAction.setPresentationMode(project, !settings.getPresentationMode());
    }

    public static void setPresentationMode(@Nullable Project project, boolean inPresentation) {
        UISettings settings = UISettings.getInstance();
        settings.setPresentationMode(inPresentation);
        boolean layoutStored = TogglePresentationModeAction.storeToolWindows(project);
        TogglePresentationModeAction.tweakUIDefaults(settings, inPresentation);
        Promise<?> callback2 = project == null ? Promises.resolvedPromise() : TogglePresentationModeAction.tweakFrameFullScreen(project, inPresentation);
        callback2.onProcessed(o -> {
            TogglePresentationModeAction.tweakEditorAndFireUpdateUI(settings, inPresentation);
            TogglePresentationModeAction.restoreToolWindows(project, layoutStored, inPresentation);
        });
    }

    @NotNull
    private static Promise<?> tweakFrameFullScreen(Project project, boolean inPresentation) {
        ProjectFrameHelper frame = ProjectFrameHelper.getFrameHelper(IdeFrameImpl.getActiveFrame());
        if (frame == null) {
            return Promises.resolvedPromise();
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        if (inPresentation) {
            propertiesComponent.setValue("full.screen.before.presentation.mode", String.valueOf(frame.isInFullScreen()));
            return frame.toggleFullScreen(true);
        }
        if (frame.isInFullScreen()) {
            String value2 = propertiesComponent.getValue("full.screen.before.presentation.mode");
            return frame.toggleFullScreen("true".equalsIgnoreCase(value2));
        }
        return Promises.resolvedPromise();
    }

    private static void tweakEditorAndFireUpdateUI(UISettings settings, boolean inPresentation) {
        int fontSize;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        int n = fontSize = inPresentation ? settings.getPresentationModeFontSize() : globalScheme.getEditorFontSize();
        if (inPresentation) {
            ourSavedConsoleFontSize = globalScheme.getConsoleFontSize();
            globalScheme.setConsoleFontSize(fontSize);
        } else {
            globalScheme.setConsoleFontSize(ourSavedConsoleFontSize);
        }
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (!(editor instanceof EditorEx)) continue;
            ((EditorEx)editor).setFontSize(fontSize);
        }
        UISettings.getInstance().fireUISettingsChanged();
        LafManager.getInstance().updateUI();
        EditorUtil.reinitSettings();
    }

    private static void tweakUIDefaults(UISettings settings, boolean inPresentation) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys2 = defaults.keys();
        if (inPresentation) {
            while (keys2.hasMoreElements()) {
                Object key = keys2.nextElement();
                if (!(key instanceof String)) continue;
                String name = (String)key;
                if (name.endsWith(".font")) {
                    Font font = defaults.getFont(key);
                    ourSavedValues.put(key, font);
                    continue;
                }
                if (!name.endsWith(".rowHeight")) continue;
                ourSavedValues.put(key, defaults.getInt(key));
            }
            float scaleFactor = JBUIScale.getFontScale((float)settings.getPresentationModeFontSize());
            ourSavedScaleFactor = JBUIScale.scale((float)1.0f);
            JBUIScale.setUserScaleFactor((float)scaleFactor);
            for (Object e : ourSavedValues.keySet()) {
                Object v = ourSavedValues.get(e);
                if (v instanceof Font) {
                    Font font = (Font)v;
                    defaults.put(e, new FontUIResource(font.getName(), font.getStyle(), JBUIScale.scale((int)font.getSize())));
                    continue;
                }
                if (!(v instanceof Integer)) continue;
                defaults.put(e, (Object)JBUIScale.scale((int)((Integer)v)));
            }
        } else {
            for (Object key : ourSavedValues.keySet()) {
                defaults.put(key, ourSavedValues.get(key));
            }
            JBUIScale.setUserScaleFactor((float)ourSavedScaleFactor);
            ourSavedValues.clear();
        }
    }

    private static boolean hideAllToolWindows(@NotNull ToolWindowManagerEx manager) {
        manager.clearSideStack();
        boolean hasVisible = false;
        for (String id2 : manager.getToolWindowIds()) {
            ToolWindow toolWindow = manager.getToolWindow(id2);
            if (!toolWindow.isVisible()) continue;
            toolWindow.hide(null);
            hasVisible = true;
        }
        return hasVisible;
    }

    static boolean storeToolWindows(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = manager.getLayout().copy();
        boolean hasVisible = TogglePresentationModeAction.hideAllToolWindows(manager);
        if (hasVisible) {
            manager.setLayoutToRestoreLater(layout);
            manager.activateEditorComponent();
        }
        return hasVisible;
    }

    static void restoreToolWindows(Project project, boolean needsRestore, boolean inPresentation) {
        if (project == null || !needsRestore) {
            return;
        }
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout restoreLayout = manager.getLayoutToRestoreLater();
        if (!inPresentation && restoreLayout != null) {
            manager.setLayout(restoreLayout);
        }
    }
}

