/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.google.common.base.Preconditions;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDialogBuilder
implements CreateFileFromTemplateDialog.Builder {
    private final TestAnswers myAnswers;
    private InputValidator myValidator;

    TestDialogBuilder(@NotNull TestAnswers answers) {
        this.myAnswers = answers;
    }

    @Override
    public CreateFileFromTemplateDialog.Builder setTitle(@Nls String title) {
        return this;
    }

    @Override
    public CreateFileFromTemplateDialog.Builder setValidator(InputValidator validator) {
        this.myValidator = validator;
        return this;
    }

    @Override
    public CreateFileFromTemplateDialog.Builder addKind(@Nls @NotNull String kind, @Nullable Icon icon2, @NotNull String templateName) {
        return this;
    }

    @Override
    @Nullable
    public Map<String, String> getCustomProperties() {
        return null;
    }

    @Override
    @Nullable
    public <T extends PsiElement> T show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull CreateFileFromTemplateDialog.FileCreator<T> creator) {
        if (this.myValidator != null) {
            Preconditions.checkState((boolean)this.myValidator.checkInput(this.myAnswers.myName), (String)"The answer '%s' is not valid.", (Object)this.myAnswers.myName);
            Preconditions.checkState((boolean)this.myValidator.canClose(this.myAnswers.myName), (String)"Can't close dialog with the answer '%s'.", (Object)this.myAnswers.myName);
        }
        if (this.myAnswers.myName != null && this.myAnswers.myTemplateName != null) {
            return (T)((PsiElement)creator.createFile(this.myAnswers.myName, this.myAnswers.myTemplateName));
        }
        return null;
    }

    @Override
    public <T extends PsiElement> void show(@NotNull String errorTitle, @Nullable String selectedItem, @NotNull CreateFileFromTemplateDialog.FileCreator<T> creator, Consumer<? super T> elementConsumer) {
        elementConsumer.consume(this.show(errorTitle, selectedItem, creator));
    }

    public static class TestAnswers {
        public static final DataKey<TestAnswers> KEY = DataKey.create((String)"CreateFileFromTemplateDialog.TestDataContext");
        private final String myName;
        private final String myTemplateName;

        public TestAnswers(@Nullable String name, @Nullable String templateName) {
            this.myName = name;
            this.myTemplateName = templateName;
        }
    }
}

