/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.tabs.impl.MorePopupAware;
import org.jetbrains.annotations.NotNull;

public class TabListAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        MorePopupAware morePopupAware = (MorePopupAware)e.getData(MorePopupAware.KEY);
        if (morePopupAware != null) {
            morePopupAware.showMorePopup();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setIcon(AllIcons.Actions.FindAndShowNextMatches);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean available = TabListAction.isTabListAvailable(e) || e.getPlace() == "TabsMoreToolbar";
        e.getPresentation().setEnabledAndVisible(available);
    }

    private static boolean isTabListAvailable(@NotNull AnActionEvent e) {
        MorePopupAware morePopupAware = (MorePopupAware)e.getData(MorePopupAware.KEY);
        return morePopupAware != null && morePopupAware.canShowMorePopup();
    }
}

