/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowContentAction
extends AnAction
implements DumbAware {
    public static final String ACTION_ID = "ShowContent";
    private ToolWindow myWindow;

    public ShowContentAction() {
    }

    public ShowContentAction(@NotNull ToolWindow window, JComponent c, @NotNull Disposable parentDisposable) {
        this.myWindow = window;
        AnAction original = ActionManager.getInstance().getAction(ACTION_ID);
        new ShadowAction((AnAction)this, original, c, parentDisposable);
        ActionUtil.copyFrom((AnAction)this, (String)ACTION_ID);
    }

    public void update(@NotNull AnActionEvent e) {
        ToolWindow window = this.getWindow(e);
        e.getPresentation().setEnabledAndVisible(window != null && window.getContentManager().getContentCount() > 1);
        e.getPresentation().setText(window == null || window.getContentUiType() == ToolWindowContentUiType.TABBED ? ActionsBundle.message((String)"action.ShowContent.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ShowContent.views.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow = this.getWindow(e);
        if (toolWindow != null) {
            toolWindow.showContentPopup(e.getInputEvent());
        }
    }

    @Nullable
    private ToolWindow getWindow(@NotNull AnActionEvent event) {
        ToolWindow window;
        if (this.myWindow != null) {
            return this.myWindow;
        }
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Component context = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (context == null) {
            return null;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        String toolWindowId = manager.getActiveToolWindowId();
        ToolWindow toolWindow = window = toolWindowId == null ? null : manager.getToolWindow(toolWindowId);
        if (window == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(window.getComponent(), context) ? window : null;
    }
}

