/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (!SaveAsDirectoryBasedFormatAction.isConvertableProject(project) || Messages.showOkCancelDialog((Project)project, (String)IdeBundle.message((String)"message.project.will.be.saved.and.reopened.in.new.directory.based.format", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.save.project.to.directory.based.format", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        IProjectStore store = ProjectKt.getStateStore(project);
        Path baseDir = Paths.get(store.getProjectFilePath(), new String[0]).getParent();
        Path ideaDir = baseDir.resolve(".idea");
        try {
            if (Files.isDirectory(ideaDir, new LinkOption[0])) {
                LocalFileSystem.getInstance().refreshAndFindFileByNioFile(ideaDir);
            } else {
                SaveAsDirectoryBasedFormatAction.createDir(ideaDir);
            }
            store.clearStorages();
            store.setPath(baseDir);
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            projectManager.closeAndDispose(project);
            projectManager.openProject(ideaDir.getParent(), new OpenProjectTask());
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)String.format("Unable to create '.idea' directory (%s): " + e.getMessage(), ideaDir), (String)IdeBundle.message((String)"dialog.title.error.saving.project", (Object[])new Object[0]));
        }
    }

    private static VirtualFile createDir(@NotNull Path ideaDir) throws IOException {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction(() -> VfsUtil.createDirectoryIfMissing((String)ideaDir.toString()));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setVisible(SaveAsDirectoryBasedFormatAction.isConvertableProject(project));
    }

    private static boolean isConvertableProject(@Nullable Project project) {
        return project != null && !project.isDefault() && !ProjectKt.isDirectoryBased(project);
    }
}

