/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImplKt;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickChangeKeymapAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        KeymapManagerImpl manager = (KeymapManagerImpl)KeymapManager.getInstance();
        Keymap current2 = manager.getActiveKeymap();
        List<Keymap> list2 = QuickChangeKeymapAction.getUnsortedKeymaps();
        list2.sort(KeymapManagerImplKt.getKeymapComparator());
        for (Keymap keymap2 : list2) {
            QuickChangeKeymapAction.addKeymapAction(group, manager, current2, keymap2);
        }
    }

    @NotNull
    private static List<Keymap> getUnsortedKeymaps() {
        return ((KeymapManagerImpl)KeymapManager.getInstance()).getKeymaps(KeymapSchemeManager.FILTER);
    }

    private static void addKeymapAction(@NotNull DefaultActionGroup group, final @NotNull KeymapManagerEx manager, @Nullable Keymap current2, final @NotNull Keymap keymap2) {
        group.add((AnAction)new DumbAwareAction(keymap2.getPresentableName(), "", keymap2 == current2 ? AllIcons.Actions.Forward : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                manager.setActiveKeymap(keymap2);
            }
        });
    }

    protected boolean isEnabled() {
        return QuickChangeKeymapAction.getUnsortedKeymaps().size() > 1;
    }
}

