/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeInspectionProfileAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstance(project);
        InspectionProfileImpl current2 = projectProfileManager.getCurrentProfile();
        for (InspectionProfile inspectionProfile : projectProfileManager.getProfiles()) {
            QuickChangeInspectionProfileAction.addScheme(group, projectProfileManager, current2, inspectionProfile);
        }
    }

    private static void addScheme(DefaultActionGroup group, final ProjectInspectionProfileManager projectProfileManager, InspectionProfile current2, final InspectionProfile scheme) {
        group.add((AnAction)new DumbAwareAction(scheme.getName(), "", scheme == current2 ? AllIcons.Actions.Forward : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                projectProfileManager.setRootProfile(scheme.getName());
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = QuickChangeInspectionProfileAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(project != null && InspectionProjectProfileManager.getInstance(project).getProfiles().size() > 1);
    }
}

