/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance(GotoFileItemProvider.class);
    private static final int EXACT_MATCH_DEGREE = 5000;
    private static final int DIRECTORY_MATCH_DEGREE = 0;
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project, @Nullable PsiElement context, @NotNull GotoFileModel model) {
        super(context);
        this.myProject = project;
        this.myModel = model;
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> this.doFilterElements(base, parameters2, indicator, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterElements(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        long start2 = System.currentTimeMillis();
        try {
            String pattern = parameters2.getCompletePattern();
            PsiFileSystemItem absolute = this.getFileByAbsolutePath(pattern);
            if (absolute != null && !consumer.process((Object)new FoundItemDescriptor((Object)absolute, 5000))) {
                boolean bl = true;
                return bl;
            }
            if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
                parameters2 = parameters2.withCompletePattern(pattern.substring(1));
            }
            if (!this.processItemsForPattern(base, parameters2, consumer, indicator)) {
                boolean bl = false;
                return bl;
            }
            String fixedPattern = FixingLayoutMatcher.fixLayout((String)pattern);
            boolean bl = fixedPattern == null || this.processItemsForPattern(base, parameters2.withCompletePattern(fixedPattern), consumer, indicator);
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Goto File \"" + parameters2.getCompletePattern() + "\" took " + (System.currentTimeMillis() - start2) + " ms");
            }
        }
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull ProgressIndicator indicator) {
        int index;
        String sanitized = GotoFileItemProvider.getSanitizedPattern(parameters2.getCompletePattern(), this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.processNames(FindSymbolParameters.simple(this.myProject, true), (Processor<? super String>)((Processor)grouper::processName));
        Ref hasSuggestions = Ref.create((Object)false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index))) {
            index = grouper.index;
            SuffixMatches group = grouper.nextGroup(base);
            if (group == null) break;
            if (group.processFiles(parameters2.withLocalPattern(dirMatcher.dirPattern), consumer, (Ref<Boolean>)hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    private void processNames(@NotNull FindSymbolParameters parameters2, @NotNull Processor<? super String> nameProcessor) {
        List contributors = DumbService.getDumbAwareExtensions((Project)this.myProject, (ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME);
        for (ChooseByNameContributor contributor : contributors) {
            if (contributor instanceof DefaultFileNavigationContributor) {
                FilenameIndex.processAllFileNames(nameProcessor, (GlobalSearchScope)parameters2.getSearchScope(), (IdFilter)parameters2.getIdFilter());
                continue;
            }
            this.myModel.processContributorNames(contributor, parameters2, nameProcessor);
        }
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, @NotNull GotoFileModel model) {
        return GotoFileItemProvider.removeSlashes(StringUtil.replace((String)ChooseByNamePopup.getTransformedPattern(pattern, model), (String)"\\", (String)"/"));
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        pattern = "*" + StringUtil.replace((String)StringUtil.replace((String)pattern, (String)"\\", (String)"*\\*"), (String)"/", (String)"*/*");
        return NameUtil.buildMatcher((String)pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
    }

    @NotNull
    private static String removeSlashes(@NotNull String s) {
        return StringUtil.trimLeading((String)StringUtil.trimTrailing((String)s, (char)'/'), (char)'/');
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibrary(vFile))) {
                return PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            }
        }
        return null;
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> matchQualifiers(@NotNull MinusculeMatcher qualifierMatcher, @NotNull Iterable<? extends PsiFileSystemItem> iterable) {
        ArrayList<FoundItemDescriptor<PsiFileSystemItem>> matching2 = new ArrayList<FoundItemDescriptor<PsiFileSystemItem>>();
        for (PsiFileSystemItem psiFileSystemItem : iterable) {
            ProgressManager.checkCanceled();
            String qualifier = Objects.requireNonNull(this.getParentPath(psiFileSystemItem));
            FList fragments = qualifierMatcher.matchingFragments(qualifier);
            if (fragments == null) continue;
            int gapPenalty = fragments.isEmpty() ? 0 : qualifier.length() - ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset();
            int degree = qualifierMatcher.matchingDegree(qualifier, false, fragments) - gapPenalty;
            matching2.add((FoundItemDescriptor<PsiFileSystemItem>)new FoundItemDescriptor((Object)psiFileSystemItem, degree));
        }
        if (matching2.size() > 1) {
            Comparator<FoundItemDescriptor> comparator2 = Comparator.comparing(res2 -> res2.getWeight()).reversed();
            matching2.sort(comparator2);
        }
        return matching2;
    }

    @Nullable
    private String getParentPath(@NotNull PsiFileSystemItem item) {
        String fullName = this.myModel.getFullName(item);
        return fullName == null ? null : StringUtil.getPackageName((String)FileUtilRt.toSystemIndependentName((String)fullName), (char)'/') + '/';
    }

    @NotNull
    private static JBIterable<FoundItemDescriptor<PsiFileSystemItem>> moveDirectoriesToEnd(@NotNull Iterable<FoundItemDescriptor<PsiFileSystemItem>> iterable) {
        ArrayList dirs = new ArrayList();
        return JBIterable.from(iterable).filter(res2 -> {
            if (res2.getItem() instanceof PsiDirectory) {
                dirs.add(new FoundItemDescriptor(res2.getItem(), 0));
                return false;
            }
            return true;
        }).append(dirs);
    }

    @NotNull
    private JBIterable<FoundItemDescriptor<PsiFileSystemItem>> getFilesMatchingPath(@NotNull FindSymbolParameters parameters2, @NotNull List<MatchResult> fileNames, @NotNull DirectoryPathMatcher dirMatcher, @NotNull ProgressIndicator indicator) {
        GlobalSearchScope scope = dirMatcher.narrowDown(parameters2.getSearchScope());
        FindSymbolParameters adjusted = parameters2.withScope(scope);
        List<List<MatchResult>> sortedNames = GotoFileItemProvider.sortAndGroup(fileNames, Comparator.comparing(mr -> StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)mr.elementName))));
        return JBIterable.from(sortedNames).flatMap(nameGroup -> this.getItemsForNames(indicator, adjusted, (List<? extends MatchResult>)nameGroup));
    }

    @NotNull
    private Iterable<FoundItemDescriptor<PsiFileSystemItem>> getItemsForNames(@NotNull ProgressIndicator indicator, @NotNull FindSymbolParameters parameters2, @NotNull List<? extends MatchResult> matchResults) {
        ArrayList<Object> group = new ArrayList<Object>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> matchDegrees = new HashMap<PsiFileSystemItem, Integer>();
        for (MatchResult matchResult : matchResults) {
            ProgressManager.checkCanceled();
            for (Object o : this.myModel.getElementsByName(matchResult.elementName, parameters2, indicator)) {
                PsiFileSystemItem psiItem;
                String qualifier;
                ProgressManager.checkCanceled();
                if (!(o instanceof PsiFileSystemItem) || (qualifier = this.getParentPath(psiItem = (PsiFileSystemItem)o)) == null) continue;
                group.add(psiItem);
                nesting.put(psiItem, StringUtil.countChars((CharSequence)qualifier, (char)'/'));
                matchDegrees.put(psiItem, matchResult.matchingDegree);
            }
        }
        if (group.size() > 1) {
            group.sort(this.getPathProximityComparator().thenComparing(nesting::get).thenComparing(this.myModel::getFullName));
        }
        return ContainerUtil.map(group, item -> new FoundItemDescriptor(item, ((Integer)matchDegrees.get(item)).intValue()));
    }

    private static int findMatchStartingPosition(@NotNull String candidateName, @NotNull String namePattern) {
        int namePos = candidateName.length();
        for (int i2 = namePattern.length(); i2 > 0; --i2) {
            char c = namePattern.charAt(i2 - 1);
            if (!Character.isLetterOrDigit(c) || (namePos = StringUtil.lastIndexOfIgnoreCase((String)candidateName, (char)c, (int)(namePos - 1))) >= 0) continue;
            return i2;
        }
        return 0;
    }

    @NotNull
    private static <T> List<List<T>> sortAndGroup(@NotNull List<T> items, @NotNull Comparator<? super T> comparator2) {
        return ((StreamEx)StreamEx.of(items).sorted(comparator2)).groupRuns((n1, n2) -> comparator2.compare(n1, n2) == 0).toList();
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames = new ArrayList<MatchResult>();
        final ProgressIndicator indicator;

        SuffixMatches(String pattern, @NotNull int from, ProgressIndicator indicator) {
            this.patternSuffix = pattern.substring(from);
            boolean preferStartMatches = from == 0 && !this.patternSuffix.startsWith("*");
            String matchPattern = (from > 0 ? " " : "*") + this.patternSuffix;
            NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)matchPattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
            if (preferStartMatches) {
                builder2.preferringStartMatches();
            }
            this.matcher = builder2.build();
            this.indicator = indicator;
        }

        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + '\'' + ", matchingNames=" + this.matchingNames + '}';
        }

        boolean matchName(@NotNull ChooseByNameViewModel base, String name) {
            MatchResult result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name);
            if (result2 != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull FindSymbolParameters parameters2, @NotNull Processor<? super FoundItemDescriptor<?>> processor2, @NotNull Ref<Boolean> hasSuggestions, @NotNull DirectoryPathMatcher dirMatcher) {
            Set<String> existingNames;
            MinusculeMatcher qualifierMatcher = GotoFileItemProvider.getQualifiedNameMatcher(parameters2.getLocalPatternName());
            List matchingNames = this.matchingNames;
            if (this.patternSuffix.length() <= 3 && !dirMatcher.dirPattern.isEmpty() && (existingNames = dirMatcher.findFileNamesMatchingIfCheap(this.patternSuffix.charAt(0), this.matcher)) != null) {
                matchingNames = ContainerUtil.filter(matchingNames, mr -> existingNames.contains(mr.elementName));
            }
            List<List<MatchResult>> groups = this.groupByMatchingDegree(matchingNames);
            for (List<MatchResult> group : groups) {
                Processor trackingProcessor;
                JBIterable matchedFiles;
                JBIterable filesMatchingPath = GotoFileItemProvider.this.getFilesMatchingPath(parameters2, group, dirMatcher, this.indicator);
                Object object = matchedFiles = parameters2.getLocalPatternName().isEmpty() ? filesMatchingPath : GotoFileItemProvider.this.matchQualifiers(qualifierMatcher, (Iterable)filesMatchingPath.map(res2 -> (PsiFileSystemItem)res2.getItem()));
                if (ContainerUtil.process((Iterable)(matchedFiles = GotoFileItemProvider.moveDirectoriesToEnd((Iterable)matchedFiles)), (Processor)(trackingProcessor = res2 -> {
                    hasSuggestions.set((Object)true);
                    return processor2.process(res2);
                }))) continue;
                return false;
            }
            return (Boolean)hasSuggestions.get() != false || parameters2.isSearchInLibraries() || !this.hasSuggestionsOutsideProject(parameters2.getCompletePattern(), groups, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, @NotNull List<? extends List<MatchResult>> groups, @NotNull DirectoryPathMatcher dirMatcher) {
            return ContainerUtil.exists(groups, group -> !GotoFileItemProvider.this.getFilesMatchingPath(FindSymbolParameters.wrap(pattern, GotoFileItemProvider.this.myProject, true), group, dirMatcher, this.indicator).isEmpty());
        }

        @NotNull
        private List<List<MatchResult>> groupByMatchingDegree(@NotNull List<MatchResult> matchingNames) {
            Comparator comparator2 = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith((CharSequence)mr1.elementName, (CharSequence)this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith((CharSequence)mr2.elementName, (CharSequence)this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2);
            };
            return GotoFileItemProvider.sortAndGroup(matchingNames, comparator2);
        }
    }

    private class NameGrouper {
        private final String namePattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            this.namePattern = namePattern;
            this.candidateNames = IntStreamEx.range((int)0, (int)namePattern.length()).mapToObj(__ -> new ArrayList()).toList();
            this.indicator = indicator;
        }

        boolean processName(@NotNull String name) {
            this.indicator.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name, this.namePattern);
            if (position < this.namePattern.length()) {
                this.candidateNames.get(position).add(name);
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(@NotNull ChooseByNameViewModel base) {
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches2 = new SuffixMatches(this.namePattern, this.index, this.indicator);
            for (String name : this.candidateNames.get(this.index)) {
                if (matches2.matchName(base, name) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches2;
        }
    }
}

