/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.SearchEverywhereBaseAction;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;

public class GotoClassAction
extends SearchEverywhereBaseAction
implements DumbAware {
    public GotoClassAction() {
        Presentation presentation2 = this.getTemplatePresentation();
        presentation2.setText(() -> IdeBundle.message((String)"go.to.class.title.prefix", (Object[])new Object[]{GotoClassPresentationUpdater.getActionTitle() + "..."}));
        presentation2.setDescription(() -> IdeBundle.message((String)"go.to.class.action.description", (Object[])new Object[]{StringUtil.join(GotoClassPresentationUpdater.getElementKinds(), (String)"/")}));
        this.addTextOverride("MainMenu", () -> GotoClassPresentationUpdater.getActionTitle() + "...");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        boolean dumb = DumbService.isDumb((Project)project);
        if (!dumb || GotoClassAction.isModelDumbAware(e)) {
            this.showInSearchEverywherePopup(ClassSearchEverywhereContributor.class.getSimpleName(), e, true, true);
        } else {
            GotoClassAction.invokeGoToFile(project, e);
        }
    }

    private static boolean isModelDumbAware(AnActionEvent e) {
        return new GotoClassModel2((Project)e.getRequiredData(CommonDataKeys.PROJECT)).isDumbAware();
    }

    static void invokeGoToFile(@NotNull Project project, @NotNull AnActionEvent e) {
        String actionTitle = StringUtil.trimEnd((String)((String)ObjectUtils.notNull((Object)e.getPresentation().getText(), (Object)GotoClassPresentationUpdater.getActionTitle())), (String)"...");
        String message = IdeBundle.message((String)"go.to.class.dumb.mode.message", (Object[])new Object[]{actionTitle});
        DumbService.getInstance((Project)project).showDumbModeNotification(message);
        AnAction action2 = ActionManager.getInstance().getAction("GotoFile");
        InputEvent event = ActionCommand.getInputEvent("GotoFile");
        Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        ActionManager.getInstance().tryToExecute(action2, event, component2, e.getPlace(), true);
    }

    @Override
    protected boolean hasContributors(@NotNull DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }
}

