/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.TestDialogBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateAction<T extends PsiElement>
extends AnAction
implements WriteActionAware {
    protected static final Logger LOG = Logger.getInstance(CreateFromTemplateAction.class);

    public CreateFromTemplateAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text, description, icon2);
    }

    public CreateFromTemplateAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
        super(dynamicText, dynamicDescription, icon2);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project == null) {
            return;
        }
        CreateFileFromTemplateDialog.Builder builder2 = CreateFromTemplateAction.createDialogBuilder(project, dataContext);
        this.buildDialog(project, dir, builder2);
        final Ref selectedTemplateName = Ref.create(null);
        builder2.show(this.getErrorTitle(), this.getDefaultTemplateName(dir), new CreateFileFromTemplateDialog.FileCreator<T>(){

            @Override
            public T createFile(@NotNull String name, @NotNull String templateName) {
                selectedTemplateName.set((Object)templateName);
                return CreateFromTemplateAction.this.createFile(name, templateName, dir);
            }

            @Override
            public boolean startInWriteAction() {
                return CreateFromTemplateAction.this.startInWriteAction();
            }

            @Override
            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                return CreateFromTemplateAction.this.getActionName(dir, name, templateName);
            }
        }, createdElement -> {
            if (createdElement != null) {
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                int offset = CreateFromTemplateAction.getOffsetToPreserve(editor);
                view.selectElement(createdElement);
                if (offset != -1 && editor != null && !editor.isDisposed()) {
                    editor.getCaretModel().moveToOffset(offset);
                }
                this.postProcess(createdElement, (String)selectedTemplateName.get(), builder2.getCustomProperties());
            }
        });
    }

    private static CreateFileFromTemplateDialog.Builder createDialogBuilder(Project project, DataContext dataContext) {
        TestDialogBuilder.TestAnswers answers;
        if (ApplicationManager.getApplication().isUnitTestMode() && (answers = (TestDialogBuilder.TestAnswers)dataContext.getData(TestDialogBuilder.TestAnswers.KEY)) != null) {
            return new TestDialogBuilder(answers);
        }
        return CreateFileFromTemplateDialog.createDialog(project);
    }

    protected void postProcess(@NotNull T createdElement, String templateName, Map<String, String> customProperties2) {
    }

    @Nullable
    protected abstract T createFile(String var1, String var2, PsiDirectory var3);

    protected abstract void buildDialog(@NotNull Project var1, @NotNull PsiDirectory var2, @NotNull CreateFileFromTemplateDialog.Builder var3);

    @NonNls
    @Nullable
    protected String getDefaultTemplateName(@NotNull PsiDirectory dir) {
        String property = this.getDefaultTemplateProperty();
        return property == null ? null : PropertiesComponent.getInstance((Project)dir.getProject()).getValue(property);
    }

    @NonNls
    @Nullable
    protected String getDefaultTemplateProperty() {
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation2 = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation2.setEnabledAndVisible(enabled);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return project != null && view != null && view.getDirectories().length != 0;
    }

    protected abstract @NlsContexts.Command String getActionName(PsiDirectory var1, @NonNls @NotNull String var2, @NonNls String var3);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    private static Integer getOffsetToPreserve(Editor editor) {
        if (editor == null) {
            return -1;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return -1;
        }
        return offset;
    }

    public static void moveCaretAfterNameIdentifier(PsiNameIdentifierOwner createdElement) {
        PsiElement nameIdentifier;
        VirtualFile virtualFile;
        Project project = createdElement.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null && (virtualFile = createdElement.getContainingFile().getVirtualFile()) != null && FileDocumentManager.getInstance().getDocument(virtualFile) == editor.getDocument() && (nameIdentifier = createdElement.getNameIdentifier()) != null) {
            editor.getCaretModel().moveToOffset(nameIdentifier.getTextRange().getEndOffset());
        }
    }
}

